/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.objtypes.JsonObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JsonObj", generator="Immutables")
@Immutable
public final class ImmutableJsonObj
implements JsonObj {
    private final ObjId id;
    private final JsonObj.JsonBean bean;

    private ImmutableJsonObj(ObjId id, JsonObj.JsonBean bean) {
        this.id = id;
        this.bean = bean;
    }

    @Override
    @JsonProperty(value="id")
    @JsonIgnore
    @JacksonInject(value="nessie.storage.ObjId")
    public ObjId id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="bean")
    @JsonUnwrapped
    public JsonObj.JsonBean bean() {
        return this.bean;
    }

    public final ImmutableJsonObj withId(ObjId value) {
        if (this.id == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "id");
        return new ImmutableJsonObj(newValue, this.bean);
    }

    public final ImmutableJsonObj withBean(JsonObj.JsonBean value) {
        if (this.bean == value) {
            return this;
        }
        JsonObj.JsonBean newValue = Objects.requireNonNull(value, "bean");
        return new ImmutableJsonObj(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJsonObj && this.equalTo(0, (ImmutableJsonObj)another);
    }

    private boolean equalTo(int synthetic, ImmutableJsonObj another) {
        return this.id.equals(another.id) && this.bean.equals(another.bean);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.bean.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JsonObj").omitNullValues().add("id", (Object)this.id).add("bean", (Object)this.bean).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJsonObj fromJson(Json json) {
        Builder builder = ImmutableJsonObj.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.bean != null) {
            builder.bean(json.bean);
        }
        return builder.build();
    }

    public static ImmutableJsonObj copyOf(JsonObj instance) {
        if (instance instanceof ImmutableJsonObj) {
            return (ImmutableJsonObj)instance;
        }
        return ImmutableJsonObj.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JsonObj", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_BEAN = 2L;
        private long initBits = 3L;
        @Nullable
        private ObjId id;
        @Nullable
        private JsonObj.JsonBean bean;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JsonObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Obj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Obj instance;
            long bits = 0L;
            if (object instanceof JsonObj) {
                instance = (JsonObj)object;
                this.bean(instance.bean());
                if ((bits & 1L) == 0L) {
                    this.id(instance.id());
                    bits |= 1L;
                }
            }
            if (object instanceof Obj) {
                instance = (Obj)object;
                if ((bits & 1L) == 0L) {
                    this.id(instance.id());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="id")
        @JsonIgnore
        @JacksonInject(value="nessie.storage.ObjId")
        @CanIgnoreReturnValue
        public final Builder id(ObjId id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="bean")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder bean(JsonObj.JsonBean bean) {
            this.bean = Objects.requireNonNull(bean, "bean");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableJsonObj build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJsonObj(this.id, this.bean);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bean");
            }
            return "Cannot build JsonObj, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JsonObj", generator="Immutables")
    static final class Json
    implements JsonObj {
        @Nullable
        ObjId id;
        @Nullable
        JsonObj.JsonBean bean;

        Json() {
        }

        @JsonProperty(value="id")
        @JsonIgnore
        @JacksonInject(value="nessie.storage.ObjId")
        public void setId(ObjId id) {
            this.id = id;
        }

        @JsonProperty(value="bean")
        @JsonUnwrapped
        public void setBean(JsonObj.JsonBean bean) {
            this.bean = bean;
        }

        @Override
        public ObjId id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JsonObj.JsonBean bean() {
            throw new UnsupportedOperationException();
        }
    }
}

