/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableIndexSegmentsObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.objtypes.StandardObjType;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjIdHasher;
import org.projectnessie.versioned.storage.common.persist.ObjType;

@Value.Immutable
public interface IndexSegmentsObj
extends Obj {
    @Override
    default public ObjType type() {
        return StandardObjType.INDEX_SEGMENTS;
    }

    @Override
    @Nullable
    @Value.Parameter(order=1)
    public ObjId id();

    @Value.Parameter(order=2)
    public List<IndexStripe> stripes();

    @Nonnull
    public static IndexSegmentsObj indexSegments(@Nullable ObjId id, @Nonnull List<IndexStripe> stripes) {
        return ImmutableIndexSegmentsObj.of(id, stripes);
    }

    @Nonnull
    public static IndexSegmentsObj indexSegments(@Nonnull List<IndexStripe> stripes) {
        return IndexSegmentsObj.indexSegments(ObjIdHasher.objIdHasher(StandardObjType.INDEX_SEGMENTS).hashCollection(stripes).generate(), stripes);
    }
}

