/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.util;

public final class Hex {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    public static char hexChar(byte b) {
        return HEX[b & 0xF];
    }

    public static long stringToLong(String s, int off) {
        long l = (long)Hex.nibble(s.charAt(off++)) << 60;
        l |= (long)Hex.nibble(s.charAt(off++)) << 56;
        l |= (long)Hex.nibble(s.charAt(off++)) << 52;
        l |= (long)Hex.nibble(s.charAt(off++)) << 48;
        l |= (long)Hex.nibble(s.charAt(off++)) << 44;
        l |= (long)Hex.nibble(s.charAt(off++)) << 40;
        l |= (long)Hex.nibble(s.charAt(off++)) << 36;
        l |= (long)Hex.nibble(s.charAt(off++)) << 32;
        l |= (long)Hex.nibble(s.charAt(off++)) << 28;
        l |= (long)Hex.nibble(s.charAt(off++)) << 24;
        l |= (long)Hex.nibble(s.charAt(off++)) << 20;
        l |= (long)Hex.nibble(s.charAt(off++)) << 16;
        l |= (long)Hex.nibble(s.charAt(off++)) << 12;
        l |= (long)Hex.nibble(s.charAt(off++)) << 8;
        l |= (long)Hex.nibble(s.charAt(off++)) << 4;
        return l |= (long)Hex.nibble(s.charAt(off));
    }

    public static int nibbleFromLong(long v, int index) {
        return (int)(v >> (int)(60L - (long)index * 4L)) & 0xF;
    }

    public static byte nibble(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        throw new IllegalArgumentException("Illegal hex character '" + c + "'");
    }
}

