/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.UniqueIdObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UniqueIdObj", generator="Immutables")
@Immutable
public final class ImmutableUniqueIdObj
implements UniqueIdObj {
    @jakarta.annotation.Nullable
    private final ObjId id;
    private final String space;
    private final ByteString value;

    private ImmutableUniqueIdObj(@jakarta.annotation.Nullable ObjId id, String space, ByteString value) {
        this.id = id;
        this.space = Objects.requireNonNull(space, "space");
        this.value = Objects.requireNonNull(value, "value");
    }

    private ImmutableUniqueIdObj(ImmutableUniqueIdObj original, @jakarta.annotation.Nullable ObjId id, String space, ByteString value) {
        this.id = id;
        this.space = space;
        this.value = value;
    }

    @Override
    @jakarta.annotation.Nullable
    public ObjId id() {
        return this.id;
    }

    @Override
    public String space() {
        return this.space;
    }

    @Override
    public ByteString value() {
        return this.value;
    }

    public final ImmutableUniqueIdObj withId(@jakarta.annotation.Nullable ObjId value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableUniqueIdObj(this, value, this.space, this.value);
    }

    public final ImmutableUniqueIdObj withSpace(String value) {
        String newValue = Objects.requireNonNull(value, "space");
        if (this.space.equals(newValue)) {
            return this;
        }
        return new ImmutableUniqueIdObj(this, this.id, newValue, this.value);
    }

    public final ImmutableUniqueIdObj withValue(ByteString value) {
        if (this.value == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "value");
        return new ImmutableUniqueIdObj(this, this.id, this.space, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUniqueIdObj && this.equalTo(0, (ImmutableUniqueIdObj)another);
    }

    private boolean equalTo(int synthetic, ImmutableUniqueIdObj another) {
        return Objects.equals(this.id, another.id) && this.space.equals(another.space) && this.value.equals((Object)another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.space.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UniqueIdObj").omitNullValues().add("id", (Object)this.id).add("space", (Object)this.space).add("value", (Object)this.value).toString();
    }

    public static ImmutableUniqueIdObj of(@jakarta.annotation.Nullable ObjId id, String space, ByteString value) {
        return new ImmutableUniqueIdObj(id, space, value);
    }

    public static ImmutableUniqueIdObj copyOf(UniqueIdObj instance) {
        if (instance instanceof ImmutableUniqueIdObj) {
            return (ImmutableUniqueIdObj)instance;
        }
        return ImmutableUniqueIdObj.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UniqueIdObj", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SPACE = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private ObjId id;
        @Nullable
        private String space;
        @Nullable
        private ByteString value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Obj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UniqueIdObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ObjId idValue;
            Obj instance;
            long bits = 0L;
            if (object instanceof Obj) {
                instance = (Obj)object;
                if ((bits & 1L) == 0L) {
                    idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof UniqueIdObj) {
                instance = (UniqueIdObj)object;
                this.value(instance.value());
                this.space(instance.space());
                if ((bits & 1L) == 0L) {
                    idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(@jakarta.annotation.Nullable ObjId id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder space(String space) {
            this.space = Objects.requireNonNull(space, "space");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(ByteString value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUniqueIdObj build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUniqueIdObj(null, this.id, this.space, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("space");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build UniqueIdObj, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

