/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import jakarta.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableRefObj;
import org.projectnessie.versioned.storage.common.objtypes.StandardObjType;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjIdHasher;
import org.projectnessie.versioned.storage.common.persist.ObjType;

@Value.Immutable
public interface RefObj
extends Obj {
    @Override
    default public ObjType type() {
        return StandardObjType.REF;
    }

    @Value.Parameter(order=1)
    public String name();

    @Override
    @Nullable
    @Value.Parameter(order=1)
    public ObjId id();

    @Value.Parameter(order=2)
    public ObjId initialPointer();

    @Value.Parameter(order=3)
    public long createdAtMicros();

    @Nullable
    @Value.Parameter(order=4)
    public ObjId extendedInfoObj();

    public static RefObj ref(ObjId id, String name, ObjId initialPointer, long createdAtMicros, ObjId extendedInfoObj) {
        return ImmutableRefObj.of(name, id, initialPointer, createdAtMicros, extendedInfoObj);
    }

    public static RefObj ref(String name, ObjId initialPointer, long createdAtMicros, ObjId extendedInfoObj) {
        return RefObj.ref(ObjIdHasher.objIdHasher(StandardObjType.REF).hash(name).hash(initialPointer.asByteArray()).hash(createdAtMicros).generate(), name, initialPointer, createdAtMicros, extendedInfoObj);
    }
}

