/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb.serializers;

import java.util.ArrayList;
import java.util.Map;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.projectnessie.versioned.storage.common.objtypes.StringObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBSerde;
import org.projectnessie.versioned.storage.dynamodb.serializers.ObjSerializer;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class StringObjSerializer
implements ObjSerializer<StringObj> {
    public static final StringObjSerializer INSTANCE = new StringObjSerializer();
    private static final String COL_STRING = "s";
    private static final String COL_STRING_CONTENT_TYPE = "y";
    private static final String COL_STRING_COMPRESSION = "c";
    private static final String COL_STRING_FILENAME = "f";
    private static final String COL_STRING_PREDECESSORS = "p";
    private static final String COL_STRING_TEXT = "t";

    private StringObjSerializer() {
    }

    @Override
    public String attributeName() {
        return COL_STRING;
    }

    @Override
    public void toMap(StringObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) {
        String s = obj.contentType();
        if (s != null && !s.isEmpty()) {
            i.put(COL_STRING_CONTENT_TYPE, AttributeValue.fromS((String)s));
        }
        i.put(COL_STRING_COMPRESSION, AttributeValue.fromS((String)obj.compression().name()));
        s = obj.filename();
        if (s != null && !s.isEmpty()) {
            i.put(COL_STRING_FILENAME, AttributeValue.fromS((String)s));
        }
        DynamoDBSerde.objIdsAttribute(i, COL_STRING_PREDECESSORS, obj.predecessors());
        DynamoDBSerde.bytesAttribute(i, COL_STRING_TEXT, obj.text());
    }

    @Override
    public StringObj fromMap(ObjId id, ObjType type, long referenced, Map<String, AttributeValue> i, String versionToken) {
        ArrayList predecessors = new ArrayList();
        DynamoDBSerde.attributeToObjIds(i, COL_STRING_PREDECESSORS, predecessors::add);
        return StringObj.stringData((ObjId)id, (long)referenced, (String)DynamoDBSerde.attributeToString(i, COL_STRING_CONTENT_TYPE), (Compression)Compression.valueOf((String)DynamoDBSerde.attributeToString(i, COL_STRING_COMPRESSION)), (String)DynamoDBSerde.attributeToString(i, COL_STRING_FILENAME), predecessors, (ByteString)DynamoDBSerde.attributeToBytes(i, COL_STRING_TEXT));
    }
}

