/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.UnsafeByteOperations;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public final class DynamoDBSerde {
    private static final String COL_STRIPES_FIRST_KEY = "f";
    private static final String COL_STRIPES_LAST_KEY = "l";
    private static final String COL_STRIPES_SEGMENT = "s";

    private DynamoDBSerde() {
    }

    public static void attributeToObjIds(Map<String, AttributeValue> i, String n, Consumer<ObjId> receiver) {
        AttributeValue v = i.get(n);
        if (v != null) {
            v.l().stream().map(el -> ObjId.objIdFromByteBuffer((ByteBuffer)el.b().asByteBuffer())).forEach(receiver);
        }
    }

    public static String attributeToString(Map<String, AttributeValue> i, String n) {
        AttributeValue v = i.get(n);
        return v != null ? v.s() : null;
    }

    public static ByteString attributeToBytes(Map<String, AttributeValue> i, String n) {
        AttributeValue v = i.get(n);
        return v != null ? UnsafeByteOperations.unsafeWrap((byte[])v.b().asByteArrayUnsafe()) : null;
    }

    public static boolean attributeToBool(Map<String, AttributeValue> i, String n) {
        AttributeValue v = i.get(n);
        if (v == null) {
            return false;
        }
        Boolean b = v.bool();
        return b != null && b != false;
    }

    public static ObjId attributeToObjId(Map<String, AttributeValue> i, String n) {
        return DynamoDBSerde.attributeToObjId(i.get(n));
    }

    public static ObjId attributeToObjId(AttributeValue v) {
        return v == null ? null : ObjId.objIdFromByteBuffer((ByteBuffer)v.b().asByteBuffer());
    }

    public static void objIdToAttribute(Map<String, AttributeValue> i, String n, ObjId id) {
        i.put(n, id != null ? AttributeValue.fromB((SdkBytes)SdkBytes.fromByteBuffer((ByteBuffer)id.asByteBuffer())) : null);
    }

    public static void objIdsAttribute(Map<String, AttributeValue> i, String n, List<ObjId> l) {
        if (l == null || l.isEmpty()) {
            return;
        }
        i.put(n, AttributeValue.fromL(l.stream().map(ObjId::asByteBuffer).map(SdkBytes::fromByteBuffer).map(AttributeValue::fromB).collect(Collectors.toList())));
    }

    public static void bytesAttribute(Map<String, AttributeValue> i, String n, ByteString b) {
        i.put(n, AttributeValue.fromB((SdkBytes)SdkBytes.fromByteBuffer((ByteBuffer)b.asReadOnlyByteBuffer())));
    }

    public static void fromStripesAttrList(AttributeValue attrList, Consumer<IndexStripe> consumer) {
        if (attrList != null) {
            for (AttributeValue seg : attrList.l()) {
                Map m = seg.m();
                consumer.accept(IndexStripe.indexStripe((StoreKey)StoreKey.keyFromString((String)DynamoDBSerde.attributeToString(m, COL_STRIPES_FIRST_KEY)), (StoreKey)StoreKey.keyFromString((String)DynamoDBSerde.attributeToString(m, COL_STRIPES_LAST_KEY)), (ObjId)DynamoDBSerde.attributeToObjId(m, COL_STRIPES_SEGMENT)));
            }
        }
    }

    public static AttributeValue stripesAttrList(List<IndexStripe> stripes) {
        ArrayList<AttributeValue> stripeAttr = new ArrayList<AttributeValue>();
        for (IndexStripe stripe : stripes) {
            HashMap<String, AttributeValue> sv = new HashMap<String, AttributeValue>();
            sv.put(COL_STRIPES_FIRST_KEY, AttributeValue.fromS((String)stripe.firstKey().rawString()));
            sv.put(COL_STRIPES_LAST_KEY, AttributeValue.fromS((String)stripe.lastKey().rawString()));
            DynamoDBSerde.objIdToAttribute(sv, COL_STRIPES_SEGMENT, stripe.segment());
            stripeAttr.add(AttributeValue.fromM(sv));
        }
        return AttributeValue.fromL(stripeAttr);
    }
}

