/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb.serializers;

import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.StandardObjType;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.dynamodb.serializers.CommitObjSerializer;
import org.projectnessie.versioned.storage.dynamodb.serializers.ContentValueObjSerializer;
import org.projectnessie.versioned.storage.dynamodb.serializers.CustomObjSerializer;
import org.projectnessie.versioned.storage.dynamodb.serializers.IndexObjSerializer;
import org.projectnessie.versioned.storage.dynamodb.serializers.IndexSegmentsObjSerializer;
import org.projectnessie.versioned.storage.dynamodb.serializers.ObjSerializer;
import org.projectnessie.versioned.storage.dynamodb.serializers.RefObjSerializer;
import org.projectnessie.versioned.storage.dynamodb.serializers.StringObjSerializer;
import org.projectnessie.versioned.storage.dynamodb.serializers.TagObjSerializer;
import org.projectnessie.versioned.storage.dynamodb.serializers.UniqueIdObjSerializer;

public final class ObjSerializers {
    public static final Set<ObjSerializer<?>> ALL_SERIALIZERS = Set.of(CommitObjSerializer.INSTANCE, ContentValueObjSerializer.INSTANCE, IndexSegmentsObjSerializer.INSTANCE, IndexObjSerializer.INSTANCE, RefObjSerializer.INSTANCE, StringObjSerializer.INSTANCE, TagObjSerializer.INSTANCE, UniqueIdObjSerializer.INSTANCE, CustomObjSerializer.INSTANCE);

    @Nonnull
    public static ObjSerializer<Obj> forType(@Nonnull ObjType type) {
        ObjSerializer<CommitObj> serializer;
        block11: {
            block10: {
                if (!(type instanceof StandardObjType)) break block10;
                switch ((StandardObjType)type) {
                    case COMMIT: {
                        serializer = CommitObjSerializer.INSTANCE;
                        break block11;
                    }
                    case INDEX_SEGMENTS: {
                        serializer = IndexSegmentsObjSerializer.INSTANCE;
                        break block11;
                    }
                    case INDEX: {
                        serializer = IndexObjSerializer.INSTANCE;
                        break block11;
                    }
                    case REF: {
                        serializer = RefObjSerializer.INSTANCE;
                        break block11;
                    }
                    case STRING: {
                        serializer = StringObjSerializer.INSTANCE;
                        break block11;
                    }
                    case TAG: {
                        serializer = TagObjSerializer.INSTANCE;
                        break block11;
                    }
                    case VALUE: {
                        serializer = ContentValueObjSerializer.INSTANCE;
                        break block11;
                    }
                    case UNIQUE: {
                        serializer = UniqueIdObjSerializer.INSTANCE;
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown standard object type: " + String.valueOf(type));
                    }
                }
            }
            serializer = CustomObjSerializer.INSTANCE;
        }
        CommitObjSerializer cast = serializer;
        return cast;
    }

    static {
        HashSet attributeNames = new HashSet();
        ALL_SERIALIZERS.forEach(serializer -> {
            String fieldName = Objects.requireNonNull(serializer.attributeName());
            if (!attributeNames.add(fieldName)) {
                throw new IllegalStateException("Duplicate attribute name: " + fieldName);
            }
        });
    }
}

