/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBBackendConfig;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@Generated(from="DynamoDBBackendConfig", generator="Immutables")
public final class ImmutableDynamoDBBackendConfig
implements DynamoDBBackendConfig {
    private final DynamoDbClient client;
    private final String tablePrefix;

    private ImmutableDynamoDBBackendConfig(DynamoDbClient client, String tablePrefix) {
        this.client = client;
        this.tablePrefix = tablePrefix;
    }

    @Override
    public DynamoDbClient client() {
        return this.client;
    }

    @Override
    public Optional<String> tablePrefix() {
        return Optional.ofNullable(this.tablePrefix);
    }

    public final ImmutableDynamoDBBackendConfig withClient(DynamoDbClient value) {
        if (this.client == value) {
            return this;
        }
        DynamoDbClient newValue = Objects.requireNonNull(value, "client");
        return new ImmutableDynamoDBBackendConfig(newValue, this.tablePrefix);
    }

    public final ImmutableDynamoDBBackendConfig withTablePrefix(String value) {
        String newValue = Objects.requireNonNull(value, "tablePrefix");
        if (Objects.equals(this.tablePrefix, newValue)) {
            return this;
        }
        return new ImmutableDynamoDBBackendConfig(this.client, newValue);
    }

    public final ImmutableDynamoDBBackendConfig withTablePrefix(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tablePrefix, value)) {
            return this;
        }
        return new ImmutableDynamoDBBackendConfig(this.client, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDynamoDBBackendConfig && this.equalsByValue((ImmutableDynamoDBBackendConfig)another);
    }

    private boolean equalsByValue(ImmutableDynamoDBBackendConfig another) {
        return this.client.equals((Object)another.client) && Objects.equals(this.tablePrefix, another.tablePrefix);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + Objects.hashCode(this.tablePrefix);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DynamoDBBackendConfig").omitNullValues().add("client", (Object)this.client).add("tablePrefix", (Object)this.tablePrefix).toString();
    }

    public static ImmutableDynamoDBBackendConfig copyOf(DynamoDBBackendConfig instance) {
        if (instance instanceof ImmutableDynamoDBBackendConfig) {
            return (ImmutableDynamoDBBackendConfig)instance;
        }
        return ImmutableDynamoDBBackendConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DynamoDBBackendConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CLIENT = 1L;
        private long initBits = 1L;
        private DynamoDbClient client;
        private String tablePrefix;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DynamoDBBackendConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.client(instance.client());
            Optional<String> tablePrefixOptional = instance.tablePrefix();
            if (tablePrefixOptional.isPresent()) {
                this.tablePrefix(tablePrefixOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(DynamoDbClient client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tablePrefix(String tablePrefix) {
            this.tablePrefix = Objects.requireNonNull(tablePrefix, "tablePrefix");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tablePrefix(Optional<String> tablePrefix) {
            this.tablePrefix = tablePrefix.orElse(null);
            return this;
        }

        public ImmutableDynamoDBBackendConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDynamoDBBackendConfig(this.client, this.tablePrefix);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("client");
            }
            return "Cannot build DynamoDBBackendConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

