/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.dynamodb.DynamoClientProducer;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DynamoClientProducer", generator="Immutables")
@Immutable
public final class ImmutableDynamoClientProducer
extends DynamoClientProducer {
    private final String endpointURI;
    private final String region;
    private final AwsCredentialsProvider credentialsProvider;

    private ImmutableDynamoClientProducer(String endpointURI, String region, AwsCredentialsProvider credentialsProvider) {
        this.endpointURI = endpointURI;
        this.region = region;
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    String endpointURI() {
        return this.endpointURI;
    }

    @Override
    String region() {
        return this.region;
    }

    @Override
    AwsCredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    public final ImmutableDynamoClientProducer withEndpointURI(String value) {
        String newValue = Objects.requireNonNull(value, "endpointURI");
        if (this.endpointURI.equals(newValue)) {
            return this;
        }
        return new ImmutableDynamoClientProducer(newValue, this.region, this.credentialsProvider);
    }

    public final ImmutableDynamoClientProducer withRegion(String value) {
        String newValue = Objects.requireNonNull(value, "region");
        if (this.region.equals(newValue)) {
            return this;
        }
        return new ImmutableDynamoClientProducer(this.endpointURI, newValue, this.credentialsProvider);
    }

    public final ImmutableDynamoClientProducer withCredentialsProvider(AwsCredentialsProvider value) {
        if (this.credentialsProvider == value) {
            return this;
        }
        AwsCredentialsProvider newValue = Objects.requireNonNull(value, "credentialsProvider");
        return new ImmutableDynamoClientProducer(this.endpointURI, this.region, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDynamoClientProducer && this.equalTo(0, (ImmutableDynamoClientProducer)another);
    }

    private boolean equalTo(int synthetic, ImmutableDynamoClientProducer another) {
        return this.endpointURI.equals(another.endpointURI) && this.region.equals(another.region) && this.credentialsProvider.equals(another.credentialsProvider);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.endpointURI.hashCode();
        h += (h << 5) + this.region.hashCode();
        h += (h << 5) + this.credentialsProvider.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DynamoClientProducer").omitNullValues().add("endpointURI", (Object)this.endpointURI).add("region", (Object)this.region).add("credentialsProvider", (Object)this.credentialsProvider).toString();
    }

    public static ImmutableDynamoClientProducer copyOf(DynamoClientProducer instance) {
        if (instance instanceof ImmutableDynamoClientProducer) {
            return (ImmutableDynamoClientProducer)instance;
        }
        return ImmutableDynamoClientProducer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DynamoClientProducer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENDPOINT_U_R_I = 1L;
        private static final long INIT_BIT_REGION = 2L;
        private static final long INIT_BIT_CREDENTIALS_PROVIDER = 4L;
        private long initBits = 7L;
        @Nullable
        private String endpointURI;
        @Nullable
        private String region;
        @Nullable
        private AwsCredentialsProvider credentialsProvider;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DynamoClientProducer instance) {
            Objects.requireNonNull(instance, "instance");
            this.endpointURI(instance.endpointURI());
            this.region(instance.region());
            this.credentialsProvider(instance.credentialsProvider());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder endpointURI(String endpointURI) {
            this.endpointURI = Objects.requireNonNull(endpointURI, "endpointURI");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder region(String region) {
            this.region = Objects.requireNonNull(region, "region");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = Objects.requireNonNull(credentialsProvider, "credentialsProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableDynamoClientProducer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDynamoClientProducer(this.endpointURI, this.region, this.credentialsProvider);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("endpointURI");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("region");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("credentialsProvider");
            }
            return "Cannot build DynamoClientProducer, some of required attributes are not set " + attributes;
        }
    }
}

