/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBBackendConfig;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DynamoDBBackendConfig", generator="Immutables")
@Immutable
public final class ImmutableDynamoDBBackendConfig
implements DynamoDBBackendConfig {
    private final DynamoDbClient client;

    private ImmutableDynamoDBBackendConfig(DynamoDbClient client) {
        this.client = client;
    }

    @Override
    public DynamoDbClient client() {
        return this.client;
    }

    public final ImmutableDynamoDBBackendConfig withClient(DynamoDbClient value) {
        if (this.client == value) {
            return this;
        }
        DynamoDbClient newValue = Objects.requireNonNull(value, "client");
        return new ImmutableDynamoDBBackendConfig(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDynamoDBBackendConfig && this.equalTo(0, (ImmutableDynamoDBBackendConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableDynamoDBBackendConfig another) {
        return this.client.equals(another.client);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.client.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DynamoDBBackendConfig").omitNullValues().add("client", (Object)this.client).toString();
    }

    public static ImmutableDynamoDBBackendConfig copyOf(DynamoDBBackendConfig instance) {
        if (instance instanceof ImmutableDynamoDBBackendConfig) {
            return (ImmutableDynamoDBBackendConfig)instance;
        }
        return ImmutableDynamoDBBackendConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DynamoDBBackendConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLIENT = 1L;
        private long initBits = 1L;
        @Nullable
        private DynamoDbClient client;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DynamoDBBackendConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.client(instance.client());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(DynamoDbClient client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDynamoDBBackendConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDynamoDBBackendConfig(this.client);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("client");
            }
            return "Cannot build DynamoDBBackendConfig, some of required attributes are not set " + attributes;
        }
    }
}

