/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.versioned.storage.common.persist.Backend;
import org.projectnessie.versioned.storage.common.persist.PersistFactory;
import org.projectnessie.versioned.storage.dynamodb.BatchWrite;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBPersistFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;

final class DynamoDBBackend
implements Backend {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoDBBackend.class);
    private final DynamoDbClient client;
    private final boolean closeClient;

    DynamoDBBackend(@javax.annotation.Nonnull @Nonnull DynamoDbClient client, boolean closeClient) {
        this.client = client;
        this.closeClient = closeClient;
    }

    @javax.annotation.Nonnull
    @Nonnull
    DynamoDbClient client() {
        return this.client;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public PersistFactory createFactory() {
        return new DynamoDBPersistFactory(this);
    }

    public void close() {
        if (this.closeClient) {
            this.client.close();
        }
    }

    public void setupSchema() {
        this.createIfMissing("refs");
        this.createIfMissing("objs");
    }

    private void createIfMissing(String name) {
        if (!this.tableExists(name)) {
            this.createTable(name);
        }
    }

    private boolean tableExists(String name) {
        try {
            DescribeTableResponse table = this.client.describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(name).build());
            DynamoDBBackend.verifyKeySchema(table.table());
            return true;
        }
        catch (ResourceNotFoundException e) {
            LOGGER.debug("Didn't find table '{}', going to create one.", (Object)name, (Object)e);
            return false;
        }
    }

    private void createTable(String name) {
        this.client.createTable(b -> b.tableName(name).attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName("k").attributeType(ScalarAttributeType.S).build()}).billingMode(BillingMode.PAY_PER_REQUEST).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName("k").keyType(KeyType.HASH).build()}));
    }

    private static void verifyKeySchema(TableDescription description) {
        KeySchemaElement key;
        List elements = description.keySchema();
        if (elements.size() == 1 && (key = (KeySchemaElement)elements.get(0)).attributeName().equals("k") && key.keyType() == KeyType.HASH) {
            return;
        }
        throw new IllegalStateException(String.format("Invalid key schema for table: %s. Key schema should be a hash partitioned attribute with the name 'id'.", description.tableName()));
    }

    public String configInfo() {
        return "";
    }

    public void eraseRepositories(Set<String> repositoryIds) {
        if (repositoryIds == null || repositoryIds.isEmpty()) {
            return;
        }
        List prefixed = repositoryIds.stream().map(DynamoDBBackend::keyPrefix).collect(Collectors.toList());
        DynamoDbClient c = this.client();
        Stream.of("refs", "objs").forEach(table -> {
            try (BatchWrite batchWrite = new BatchWrite(this, (String)table);){
                c.scanPaginator(b -> b.tableName(table)).forEach(r -> r.items().stream().map(attrs -> (AttributeValue)attrs.get("k")).filter(key -> prefixed.stream().anyMatch(key.s()::startsWith)).forEach(batchWrite::addDelete));
            }
        });
    }

    static String keyPrefix(String repositoryId) {
        return repositoryId + ":";
    }

    static Condition condition(ComparisonOperator operator, AttributeValue ... values) {
        return (Condition)Condition.builder().comparisonOperator(operator).attributeValueList(values).build();
    }
}

