/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.agrona.collections.Object2IntHashMap;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.UnsafeByteOperations;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.projectnessie.versioned.storage.common.objtypes.ContentValueObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexSegmentsObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.objtypes.RefObj;
import org.projectnessie.versioned.storage.common.objtypes.StringObj;
import org.projectnessie.versioned.storage.common.objtypes.TagObj;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.dynamodb.BatchWrite;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBBackend;
import org.projectnessie.versioned.storage.serialize.ProtoSerialization;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class DynamoDBPersist
implements Persist {
    private static final Map<ObjType, StoreObjDesc<?>> STORE_OBJ_TYPE = new EnumMap(ObjType.class);
    private final DynamoDBBackend backend;
    private final StoreConfig config;
    private final String keyPrefix;

    DynamoDBPersist(DynamoDBBackend backend, StoreConfig config) {
        this.backend = backend;
        this.config = config;
        this.keyPrefix = DynamoDBBackend.keyPrefix(config.repositoryId());
    }

    @javax.annotation.Nonnull
    @Nonnull
    public String name() {
        return "DynamoDB";
    }

    public int hardObjectSizeLimit() {
        return 409600;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public StoreConfig config() {
        return this.config;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Reference addReference(@javax.annotation.Nonnull @Nonnull Reference reference) throws RefAlreadyExistsException {
        Preconditions.checkArgument((!reference.deleted() ? 1 : 0) != 0, (Object)"Deleted references must not be added");
        try {
            this.backend.client().putItem(b -> b.tableName(this.backend.tableRefs).conditionExpression("attribute_not_exists(p)").item(this.referenceAttributeValues(reference)));
            return reference;
        }
        catch (ConditionalCheckFailedException e) {
            throw new RefAlreadyExistsException(this.fetchReference(reference.name()));
        }
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Reference markReferenceAsDeleted(@javax.annotation.Nonnull @Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        try {
            reference = reference.withDeleted(false);
            Reference asDeleted = reference.withDeleted(true);
            this.conditionalReferencePut(asDeleted, reference);
            return asDeleted;
        }
        catch (ConditionalCheckFailedException e) {
            Reference r = this.fetchReference(reference.name());
            if (r == null) {
                throw new RefNotFoundException(reference.name());
            }
            throw new RefConditionFailedException(r);
        }
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Reference updateReferencePointer(@javax.annotation.Nonnull @Nonnull Reference reference, @javax.annotation.Nonnull @Nonnull ObjId newPointer) throws RefNotFoundException, RefConditionFailedException {
        try {
            reference = reference.withDeleted(false);
            Reference bumpedReference = reference.forNewPointer(newPointer, this.config);
            this.conditionalReferencePut(bumpedReference, reference);
            return bumpedReference;
        }
        catch (ConditionalCheckFailedException e) {
            Reference r = this.fetchReference(reference.name());
            if (r == null) {
                throw new RefNotFoundException(reference.name());
            }
            throw new RefConditionFailedException(r);
        }
    }

    public void purgeReference(@javax.annotation.Nonnull @Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        reference = reference.withDeleted(true);
        String condition = DynamoDBPersist.referenceCondition(reference);
        Map<String, AttributeValue> values = DynamoDBPersist.referenceConditionAttributes(reference);
        String refName = reference.name();
        try {
            this.backend.client().deleteItem(b -> b.tableName(this.backend.tableRefs).key(this.referenceKeyMap(refName)).expressionAttributeValues(values).conditionExpression(condition));
        }
        catch (ConditionalCheckFailedException e) {
            Reference r = this.fetchReference(refName);
            if (r == null) {
                throw new RefNotFoundException(refName);
            }
            throw new RefConditionFailedException(r);
        }
    }

    @javax.annotation.Nullable
    @Nullable
    public Reference fetchReference(@javax.annotation.Nonnull @Nonnull String name) {
        GetItemResponse item = this.backend.client().getItem(b -> b.tableName(this.backend.tableRefs).key(this.referenceKeyMap(name)));
        if (!item.hasItem()) {
            return null;
        }
        Map i = item.item();
        String createdAtStr = DynamoDBPersist.attributeToString(i, "c");
        long createdAt = createdAtStr != null ? Long.parseLong(createdAtStr) : 0L;
        return Reference.reference((String)name, (ObjId)DynamoDBPersist.attributeToObjId(i, "p"), (boolean)DynamoDBPersist.attributeToBool(i, "d"), (long)createdAt, (ObjId)DynamoDBPersist.attributeToObjId(i, "e"), this.attributeToPreviousPointers(i));
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Reference[] fetchReferences(@javax.annotation.Nonnull @Nonnull String[] names) {
        ArrayList<Map<String, AttributeValue>> keys = new ArrayList<Map<String, AttributeValue>>(Math.min(names.length, 100));
        Object2IntHashMap nameToIndex = new Object2IntHashMap(200, 0.65f, -1);
        Reference[] r = new Reference[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name == null) continue;
            keys.add(this.referenceKeyMap(name));
            nameToIndex.put((Object)name, i);
            if (keys.size() != 100) continue;
            this.findReferencesPage(r, keys, (Object2IntHashMap<String>)nameToIndex);
            keys.clear();
            nameToIndex.clear();
        }
        if (!keys.isEmpty()) {
            this.findReferencesPage(r, keys, (Object2IntHashMap<String>)nameToIndex);
        }
        return r;
    }

    private void findReferencesPage(Reference[] r, List<Map<String, AttributeValue>> keys, Object2IntHashMap<String> nameToIndex) {
        Map<String, KeysAndAttributes> requestItems = Collections.singletonMap(this.backend.tableRefs, (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).build());
        BatchGetItemResponse response = this.backend.client().batchGetItem(b -> b.requestItems(requestItems));
        ((List)response.responses().get(this.backend.tableRefs)).forEach(item -> {
            String name = ((AttributeValue)item.get("k")).s().substring(this.keyPrefix.length());
            String createdAtStr = DynamoDBPersist.attributeToString(item, "c");
            long createdAt = createdAtStr != null ? Long.parseLong(createdAtStr) : 0L;
            Reference reference = Reference.reference((String)name, (ObjId)DynamoDBPersist.attributeToObjId(item, "p"), (boolean)DynamoDBPersist.attributeToBool(item, "d"), (long)createdAt, (ObjId)DynamoDBPersist.attributeToObjId(item, "e"), this.attributeToPreviousPointers((Map<String, AttributeValue>)item));
            int idx = nameToIndex.getValue((Object)name);
            if (idx >= 0) {
                r[idx] = reference;
            }
        });
    }

    private List<Reference.PreviousPointer> attributeToPreviousPointers(Map<String, AttributeValue> item) {
        AttributeValue attr = item.get("h");
        if (attr == null) {
            return Collections.emptyList();
        }
        return ProtoSerialization.deserializePreviousPointers((byte[])attr.b().asByteArray());
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Obj fetchObj(@javax.annotation.Nonnull @Nonnull ObjId id) throws ObjNotFoundException {
        GetItemResponse item = this.backend.client().getItem(b -> b.tableName(this.backend.tableObjs).key(this.objKeyMap(id)));
        if (!item.hasItem()) {
            throw new ObjNotFoundException(id);
        }
        return this.decomposeObj(item.item());
    }

    @javax.annotation.Nonnull
    @Nonnull
    public <T extends Obj> T fetchTypedObj(@javax.annotation.Nonnull @Nonnull ObjId id, ObjType type, Class<T> typeClass) throws ObjNotFoundException {
        GetItemResponse item = this.backend.client().getItem(b -> b.tableName(this.backend.tableObjs).key(this.objKeyMap(id)));
        if (!item.hasItem()) {
            throw new ObjNotFoundException(id);
        }
        Obj obj = this.decomposeObj(item.item());
        if (obj.type() != type) {
            throw new ObjNotFoundException(id);
        }
        Obj r = obj;
        return (T)r;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public ObjType fetchObjType(@javax.annotation.Nonnull @Nonnull ObjId id) throws ObjNotFoundException {
        GetItemResponse item = this.backend.client().getItem(b -> b.tableName(this.backend.tableObjs).key(this.objKeyMap(id)).attributesToGet(new String[]{"y"}));
        if (!item.hasItem()) {
            throw new ObjNotFoundException(id);
        }
        return this.objTypeFromItem(item.item());
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Obj[] fetchObjs(@javax.annotation.Nonnull @Nonnull ObjId[] ids) throws ObjNotFoundException {
        ArrayList<Map<String, AttributeValue>> keys = new ArrayList<Map<String, AttributeValue>>(Math.min(ids.length, 100));
        Object2IntHashMap idToIndex = new Object2IntHashMap(200, 0.65f, -1);
        Obj[] r = new Obj[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            ObjId id = ids[i];
            if (id == null) continue;
            keys.add(this.objKeyMap(id));
            idToIndex.put((Object)id, i);
            if (keys.size() != 100) continue;
            this.fetchObjsPage(r, keys, (Object2IntHashMap<ObjId>)idToIndex);
            keys.clear();
            idToIndex.clear();
        }
        if (!keys.isEmpty()) {
            this.fetchObjsPage(r, keys, (Object2IntHashMap<ObjId>)idToIndex);
        }
        ArrayList<ObjId> notFound = null;
        for (int i = 0; i < ids.length; ++i) {
            ObjId id = ids[i];
            if (id == null || r[i] != null) continue;
            if (notFound == null) {
                notFound = new ArrayList<ObjId>();
            }
            notFound.add(id);
        }
        if (notFound != null) {
            throw new ObjNotFoundException(notFound);
        }
        return r;
    }

    private void fetchObjsPage(Obj[] r, List<Map<String, AttributeValue>> keys, Object2IntHashMap<ObjId> idToIndex) {
        Map<String, KeysAndAttributes> requestItems = Collections.singletonMap(this.backend.tableObjs, (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).build());
        BatchGetItemResponse response = this.backend.client().batchGetItem(b -> b.requestItems(requestItems));
        ((List)response.responses().get(this.backend.tableObjs)).forEach(item -> {
            Obj obj = this.decomposeObj((Map<String, AttributeValue>)item);
            int idx = idToIndex.getValue((Object)obj.id());
            if (idx != -1) {
                r[idx] = obj;
            }
        });
    }

    @javax.annotation.Nonnull
    @Nonnull
    public boolean[] storeObjs(@javax.annotation.Nonnull @Nonnull Obj[] objs) throws ObjTooLargeException {
        boolean[] r = new boolean[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            Obj o = objs[i];
            if (o == null) continue;
            r[i] = this.storeObj(o);
        }
        return r;
    }

    public boolean storeObj(@javax.annotation.Nonnull @Nonnull Obj obj, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        ObjId id = obj.id();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
        Map<String, AttributeValue> item = this.objToItem(obj, id, ignoreSoftSizeRestrictions);
        try {
            this.backend.client().putItem(b -> b.tableName(this.backend.tableObjs).conditionExpression("attribute_not_exists(y)").item(item));
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
        catch (DynamoDbException e) {
            AwsErrorDetails errorDetails = e.awsErrorDetails();
            if (DynamoDBPersist.checkItemSizeExceeded(errorDetails)) {
                throw new ObjTooLargeException();
            }
            throw e;
        }
        return true;
    }

    public void deleteObj(@javax.annotation.Nonnull @Nonnull ObjId id) {
        this.backend.client().deleteItem(b -> b.tableName(this.backend.tableObjs).key(this.objKeyMap(id)));
    }

    public void deleteObjs(@javax.annotation.Nonnull @Nonnull ObjId[] ids) {
        try (BatchWrite batchWrite = new BatchWrite(this.backend, this.backend.tableObjs);){
            for (ObjId id : ids) {
                batchWrite.addDelete(this.objKey(id));
            }
        }
    }

    public void upsertObj(@javax.annotation.Nonnull @Nonnull Obj obj) throws ObjTooLargeException {
        ObjId id = obj.id();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
        Map<String, AttributeValue> item = this.objToItem(obj, id, false);
        try {
            this.backend.client().putItem(b -> b.tableName(this.backend.tableObjs).item(item));
        }
        catch (DynamoDbException e) {
            AwsErrorDetails errorDetails = e.awsErrorDetails();
            if (DynamoDBPersist.checkItemSizeExceeded(errorDetails)) {
                throw new ObjTooLargeException();
            }
            throw e;
        }
    }

    public void upsertObjs(@javax.annotation.Nonnull @Nonnull Obj[] objs) throws ObjTooLargeException {
        try (BatchWrite batchWrite = new BatchWrite(this.backend, this.backend.tableObjs);){
            for (Obj obj : objs) {
                ObjId id = obj.id();
                Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
                Map<String, AttributeValue> item = this.objToItem(obj, id, false);
                batchWrite.addPut(item);
            }
        }
    }

    @javax.annotation.Nonnull
    @Nonnull
    public CloseableIterator<Obj> scanAllObjects(@javax.annotation.Nonnull @Nonnull Set<ObjType> returnedObjTypes) {
        return new ScanAllObjectsIterator(returnedObjTypes);
    }

    public void erase() {
        this.backend.eraseRepositories(Collections.singleton(this.config().repositoryId()));
    }

    private ObjType objTypeFromItem(Map<String, AttributeValue> item) {
        return this.objTypeFromItem(item.get("y"));
    }

    private ObjType objTypeFromItem(AttributeValue attributeValue) {
        String shortType = attributeValue.s();
        return ObjType.fromShortName((String)shortType);
    }

    private Obj decomposeObj(Map<String, AttributeValue> item) {
        ObjId id = ObjId.objIdFromString((String)item.get("k").s().substring(this.keyPrefix.length()));
        ObjType type = this.objTypeFromItem(item);
        StoreObjDesc<?> storeObj = STORE_OBJ_TYPE.get(type);
        Preconditions.checkState((storeObj != null ? 1 : 0) != 0, (String)"Cannot deserialize object type %s", (Object)type);
        Map inner = item.get(storeObj.typeName).m();
        return storeObj.fromMap(id, inner);
    }

    @javax.annotation.Nonnull
    @Nonnull
    private Map<String, AttributeValue> objToItem(@javax.annotation.Nonnull @Nonnull Obj obj, ObjId id, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        ObjType type = obj.type();
        StoreObjDesc<?> storeObj = STORE_OBJ_TYPE.get(type);
        Preconditions.checkArgument((storeObj != null ? 1 : 0) != 0, (String)"Cannot serialize object type %s ", (Object)type);
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        HashMap<String, AttributeValue> inner = new HashMap<String, AttributeValue>();
        item.put("k", this.objKey(id));
        item.put("y", AttributeValue.fromS((String)type.shortName()));
        int incrementalIndexSizeLimit = ignoreSoftSizeRestrictions ? Integer.MAX_VALUE : this.effectiveIncrementalIndexSizeLimit();
        int indexSizeLimit = ignoreSoftSizeRestrictions ? Integer.MAX_VALUE : this.effectiveIndexSegmentSizeLimit();
        storeObj.toMap(obj, inner, incrementalIndexSizeLimit, indexSizeLimit);
        item.put(storeObj.typeName, AttributeValue.fromM(inner));
        return item;
    }

    private static void fromStripesAttrList(AttributeValue attrList, Consumer<IndexStripe> consumer) {
        if (attrList != null) {
            for (AttributeValue seg : attrList.l()) {
                Map m = seg.m();
                consumer.accept(IndexStripe.indexStripe((StoreKey)StoreKey.keyFromString((String)DynamoDBPersist.attributeToString(m, "f")), (StoreKey)StoreKey.keyFromString((String)DynamoDBPersist.attributeToString(m, "l")), (ObjId)DynamoDBPersist.attributeToObjId(m, "s")));
            }
        }
    }

    private static AttributeValue stripesAttrList(List<IndexStripe> stripes) {
        ArrayList<AttributeValue> stripeAttr = new ArrayList<AttributeValue>();
        for (IndexStripe stripe : stripes) {
            HashMap<String, AttributeValue> sv = new HashMap<String, AttributeValue>();
            sv.put("f", AttributeValue.fromS((String)stripe.firstKey().rawString()));
            sv.put("l", AttributeValue.fromS((String)stripe.lastKey().rawString()));
            DynamoDBPersist.objIdToAttribute(sv, "s", stripe.segment());
            stripeAttr.add(AttributeValue.fromM(sv));
        }
        return AttributeValue.fromL(stripeAttr);
    }

    private static boolean checkItemSizeExceeded(AwsErrorDetails errorDetails) {
        return "DynamoDb".equals(errorDetails.serviceName()) && "ValidationException".equals(errorDetails.errorCode()) && errorDetails.errorMessage().toLowerCase(Locale.ROOT).contains("item size");
    }

    @javax.annotation.Nonnull
    @Nonnull
    private Map<String, AttributeValue> referenceAttributeValues(@javax.annotation.Nonnull @Nonnull Reference reference) {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put("k", this.referenceKey(reference.name()));
        DynamoDBPersist.objIdToAttribute(item, "p", reference.pointer());
        item.put("d", AttributeValue.fromBool((Boolean)reference.deleted()));
        item.put("c", DynamoDBPersist.referencesCreatedAt(reference));
        DynamoDBPersist.objIdToAttribute(item, "e", reference.extendedInfoObj());
        byte[] previousPointers = ProtoSerialization.serializePreviousPointers((List)reference.previousPointers());
        if (previousPointers != null) {
            item.put("h", AttributeValue.fromB((SdkBytes)SdkBytes.fromByteArray((byte[])previousPointers)));
        }
        return item;
    }

    private void conditionalReferencePut(@javax.annotation.Nonnull @Nonnull Reference reference, Reference expected) {
        String condition = DynamoDBPersist.referenceCondition(expected);
        Map<String, AttributeValue> values = DynamoDBPersist.referenceConditionAttributes(expected);
        this.backend.client().putItem(b -> b.tableName(this.backend.tableRefs).conditionExpression(condition).expressionAttributeValues(values).item(this.referenceAttributeValues(reference)));
    }

    private static Map<String, AttributeValue> referenceConditionAttributes(Reference reference) {
        HashMap<String, AttributeValue> values = new HashMap<String, AttributeValue>();
        DynamoDBPersist.objIdToAttribute(values, ":pointer", reference.pointer());
        values.put(":deleted", AttributeValue.fromBool((Boolean)reference.deleted()));
        values.put(":createdAt", DynamoDBPersist.referencesCreatedAt(reference));
        DynamoDBPersist.objIdToAttribute(values, ":extendedInfo", reference.extendedInfoObj());
        return values;
    }

    private static String referenceCondition(Reference reference) {
        return "(d = :deleted) AND (p = :pointer)" + (reference.createdAtMicros() != 0L ? " AND (c = :createdAt)" : " AND attribute_not_exists(c)") + (reference.extendedInfoObj() != null ? " AND (e = :extendedInfo)" : " AND attribute_not_exists(e)");
    }

    private static AttributeValue referencesCreatedAt(Reference reference) {
        long createdAt = reference.createdAtMicros();
        return createdAt == 0L ? null : AttributeValue.fromS((String)Long.toString(createdAt));
    }

    @javax.annotation.Nonnull
    @Nonnull
    private AttributeValue referenceKey(@javax.annotation.Nonnull @Nonnull String reference) {
        return AttributeValue.fromS((String)(this.keyPrefix + reference));
    }

    @javax.annotation.Nonnull
    @Nonnull
    private Map<String, AttributeValue> referenceKeyMap(@javax.annotation.Nonnull @Nonnull String reference) {
        return Collections.singletonMap("k", this.referenceKey(reference));
    }

    @javax.annotation.Nonnull
    @Nonnull
    private AttributeValue objKey(@javax.annotation.Nonnull @Nonnull ObjId id) {
        return AttributeValue.fromS((String)(this.keyPrefix + id));
    }

    @javax.annotation.Nonnull
    @Nonnull
    private Map<String, AttributeValue> objKeyMap(@javax.annotation.Nonnull @Nonnull ObjId id) {
        return Collections.singletonMap("k", this.objKey(id));
    }

    private static void attributeToObjIds(Map<String, AttributeValue> i, String n, Consumer<ObjId> receiver) {
        AttributeValue v = i.get(n);
        if (v != null) {
            v.l().stream().map(el -> ObjId.objIdFromByteBuffer((ByteBuffer)el.b().asByteBuffer())).forEach(receiver);
        }
    }

    private static String attributeToString(Map<String, AttributeValue> i, String n) {
        AttributeValue v = i.get(n);
        return v != null ? v.s() : null;
    }

    private static ByteString attributeToBytes(Map<String, AttributeValue> i, String n) {
        AttributeValue v = i.get(n);
        return v != null ? UnsafeByteOperations.unsafeWrap((byte[])v.b().asByteArrayUnsafe()) : null;
    }

    private static boolean attributeToBool(Map<String, AttributeValue> i, String n) {
        AttributeValue v = i.get(n);
        if (v == null) {
            return false;
        }
        Boolean b = v.bool();
        return b != null && b != false;
    }

    private static ObjId attributeToObjId(Map<String, AttributeValue> i, String n) {
        return DynamoDBPersist.attributeToObjId(i.get(n));
    }

    private static ObjId attributeToObjId(AttributeValue v) {
        return v == null ? null : ObjId.objIdFromByteBuffer((ByteBuffer)v.b().asByteBuffer());
    }

    private static void objIdToAttribute(Map<String, AttributeValue> i, String n, ObjId id) {
        i.put(n, id != null ? AttributeValue.fromB((SdkBytes)SdkBytes.fromByteBuffer((ByteBuffer)id.asByteBuffer())) : null);
    }

    private static void objIdsAttribute(Map<String, AttributeValue> i, String n, List<ObjId> l) {
        if (l == null || l.isEmpty()) {
            return;
        }
        i.put(n, AttributeValue.fromL(l.stream().map(ObjId::asByteBuffer).map(SdkBytes::fromByteBuffer).map(AttributeValue::fromB).collect(Collectors.toList())));
    }

    private static void bytesAttribute(Map<String, AttributeValue> i, String n, ByteString b) {
        i.put(n, AttributeValue.fromB((SdkBytes)SdkBytes.fromByteBuffer((ByteBuffer)b.asReadOnlyByteBuffer())));
    }

    static {
        STORE_OBJ_TYPE.put(ObjType.COMMIT, new StoreObjDesc<CommitObj>("c"){

            @Override
            void toMap(CommitObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) throws ObjTooLargeException {
                i.put("q", AttributeValue.fromS((String)Long.toString(obj.seq())));
                i.put("c", AttributeValue.fromS((String)Long.toString(obj.created())));
                ObjId referenceIndex = obj.referenceIndex();
                if (referenceIndex != null) {
                    DynamoDBPersist.objIdToAttribute(i, "x", referenceIndex);
                }
                i.put("m", AttributeValue.fromS((String)obj.message()));
                DynamoDBPersist.objIdsAttribute(i, "t", obj.tail());
                DynamoDBPersist.objIdsAttribute(i, "s", obj.secondaryParents());
                ByteString index = obj.incrementalIndex();
                if (index.size() > incrementalIndexSize) {
                    throw new ObjTooLargeException(index.size(), incrementalIndexSize);
                }
                DynamoDBPersist.bytesAttribute(i, "i", index);
                if (!obj.referenceIndexStripes().isEmpty()) {
                    i.put("r", DynamoDBPersist.stripesAttrList(obj.referenceIndexStripes()));
                }
                HashMap<String, AttributeValue> headerMap = new HashMap<String, AttributeValue>();
                CommitHeaders headers = obj.headers();
                for (String s : headers.keySet()) {
                    headerMap.put(s, AttributeValue.fromL(headers.getAll(s).stream().map(AttributeValue::fromS).collect(Collectors.toList())));
                }
                if (!headerMap.isEmpty()) {
                    i.put("h", AttributeValue.fromM(headerMap));
                }
                i.put("n", AttributeValue.fromBool((Boolean)obj.incompleteIndex()));
                i.put("y", AttributeValue.fromS((String)obj.commitType().shortName()));
            }

            @Override
            CommitObj fromMap(ObjId id, Map<String, AttributeValue> i) {
                CommitObj.Builder b = CommitObj.commitBuilder().id(id).seq(Long.parseLong(DynamoDBPersist.attributeToString(i, "q"))).created(Long.parseLong(DynamoDBPersist.attributeToString(i, "c"))).message(DynamoDBPersist.attributeToString(i, "m")).incrementalIndex(DynamoDBPersist.attributeToBytes(i, "i")).incompleteIndex(DynamoDBPersist.attributeToBool(i, "n")).commitType(CommitType.fromShortName((String)DynamoDBPersist.attributeToString(i, "y")));
                AttributeValue v = i.get("x");
                if (v != null) {
                    b.referenceIndex(DynamoDBPersist.attributeToObjId(v));
                }
                DynamoDBPersist.fromStripesAttrList(i.get("r"), arg_0 -> ((CommitObj.Builder)b).addReferenceIndexStripes(arg_0));
                DynamoDBPersist.attributeToObjIds(i, "t", arg_0 -> ((CommitObj.Builder)b).addTail(arg_0));
                DynamoDBPersist.attributeToObjIds(i, "s", arg_0 -> ((CommitObj.Builder)b).addSecondaryParents(arg_0));
                CommitHeaders.Builder headers = CommitHeaders.newCommitHeaders();
                AttributeValue headerMap = i.get("h");
                if (headerMap != null) {
                    headerMap.m().forEach((k, l) -> l.l().forEach(hv -> headers.add(k, hv.s())));
                }
                b.headers(headers.build());
                return b.build();
            }
        });
        STORE_OBJ_TYPE.put(ObjType.REF, new StoreObjDesc<RefObj>("e"){

            @Override
            void toMap(RefObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) {
                i.put("n", AttributeValue.fromS((String)obj.name()));
                i.put("c", AttributeValue.fromS((String)Long.toString(obj.createdAtMicros())));
                DynamoDBPersist.objIdToAttribute(i, "p", obj.initialPointer());
                ObjId extendedInfoObj = obj.extendedInfoObj();
                if (extendedInfoObj != null) {
                    DynamoDBPersist.objIdToAttribute(i, "e", extendedInfoObj);
                }
            }

            @Override
            RefObj fromMap(ObjId id, Map<String, AttributeValue> i) {
                String createdAtStr = DynamoDBPersist.attributeToString(i, "c");
                long createdAt = createdAtStr != null ? Long.parseLong(createdAtStr) : 0L;
                return RefObj.ref((ObjId)id, (String)DynamoDBPersist.attributeToString(i, "n"), (ObjId)DynamoDBPersist.attributeToObjId(i, "p"), (long)createdAt, (ObjId)DynamoDBPersist.attributeToObjId(i, "e"));
            }
        });
        STORE_OBJ_TYPE.put(ObjType.VALUE, new StoreObjDesc<ContentValueObj>("v"){

            @Override
            void toMap(ContentValueObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) {
                i.put("i", AttributeValue.fromS((String)obj.contentId()));
                i.put("p", AttributeValue.fromS((String)Integer.toString(obj.payload())));
                DynamoDBPersist.bytesAttribute(i, "d", obj.data());
            }

            @Override
            ContentValueObj fromMap(ObjId id, Map<String, AttributeValue> i) {
                return ContentValueObj.contentValue((ObjId)id, (String)DynamoDBPersist.attributeToString(i, "i"), (int)Integer.parseInt(DynamoDBPersist.attributeToString(i, "p")), (ByteString)DynamoDBPersist.attributeToBytes(i, "d"));
            }
        });
        STORE_OBJ_TYPE.put(ObjType.INDEX_SEGMENTS, new StoreObjDesc<IndexSegmentsObj>("I"){

            @Override
            void toMap(IndexSegmentsObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) {
                i.put("s", DynamoDBPersist.stripesAttrList(obj.stripes()));
            }

            @Override
            IndexSegmentsObj fromMap(ObjId id, Map<String, AttributeValue> i) {
                ArrayList stripes = new ArrayList();
                DynamoDBPersist.fromStripesAttrList(i.get("s"), stripes::add);
                return IndexSegmentsObj.indexSegments((ObjId)id, stripes);
            }
        });
        STORE_OBJ_TYPE.put(ObjType.INDEX, new StoreObjDesc<IndexObj>("i"){

            @Override
            void toMap(IndexObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) throws ObjTooLargeException {
                ByteString index = obj.index();
                if (index.size() > maxSerializedIndexSize) {
                    throw new ObjTooLargeException(index.size(), maxSerializedIndexSize);
                }
                DynamoDBPersist.bytesAttribute(i, "i", index);
            }

            @Override
            IndexObj fromMap(ObjId id, Map<String, AttributeValue> i) {
                return IndexObj.index((ObjId)id, (ByteString)DynamoDBPersist.attributeToBytes(i, "i"));
            }
        });
        STORE_OBJ_TYPE.put(ObjType.TAG, new StoreObjDesc<TagObj>("t"){

            @Override
            void toMap(TagObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) {
                ByteString signature;
                String message = obj.message();
                if (message != null) {
                    i.put("m", AttributeValue.fromS((String)message));
                }
                HashMap<String, AttributeValue> headerMap = new HashMap<String, AttributeValue>();
                CommitHeaders headers = obj.headers();
                if (headers != null) {
                    for (String s : headers.keySet()) {
                        headerMap.put(s, AttributeValue.fromL(headers.getAll(s).stream().map(AttributeValue::fromS).collect(Collectors.toList())));
                    }
                    if (!headerMap.isEmpty()) {
                        i.put("h", AttributeValue.fromM(headerMap));
                    }
                }
                if ((signature = obj.signature()) != null) {
                    DynamoDBPersist.bytesAttribute(i, "s", signature);
                }
            }

            @Override
            TagObj fromMap(ObjId id, Map<String, AttributeValue> i) {
                CommitHeaders tagHeaders = null;
                AttributeValue headerMap = i.get("h");
                if (headerMap != null) {
                    CommitHeaders.Builder headers = CommitHeaders.newCommitHeaders();
                    headerMap.m().forEach((k, l) -> l.l().forEach(hv -> headers.add(k, hv.s())));
                    tagHeaders = headers.build();
                }
                return TagObj.tag((ObjId)id, (String)DynamoDBPersist.attributeToString(i, "m"), tagHeaders, (ByteString)DynamoDBPersist.attributeToBytes(i, "s"));
            }
        });
        STORE_OBJ_TYPE.put(ObjType.STRING, new StoreObjDesc<StringObj>("s"){

            @Override
            void toMap(StringObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) {
                String s = obj.contentType();
                if (s != null && !s.isEmpty()) {
                    i.put("y", AttributeValue.fromS((String)s));
                }
                i.put("c", AttributeValue.fromS((String)obj.compression().name()));
                s = obj.filename();
                if (s != null && !s.isEmpty()) {
                    i.put("f", AttributeValue.fromS((String)s));
                }
                DynamoDBPersist.objIdsAttribute(i, "p", obj.predecessors());
                DynamoDBPersist.bytesAttribute(i, "t", obj.text());
            }

            @Override
            StringObj fromMap(ObjId id, Map<String, AttributeValue> i) {
                ArrayList predecessors = new ArrayList();
                DynamoDBPersist.attributeToObjIds(i, "p", predecessors::add);
                return StringObj.stringData((ObjId)id, (String)DynamoDBPersist.attributeToString(i, "y"), (Compression)Compression.valueOf((String)DynamoDBPersist.attributeToString(i, "c")), (String)DynamoDBPersist.attributeToString(i, "f"), predecessors, (ByteString)DynamoDBPersist.attributeToBytes(i, "t"));
            }
        });
    }

    private class ScanAllObjectsIterator
    extends AbstractIterator<Obj>
    implements CloseableIterator<Obj> {
        private final Iterator<ScanResponse> iter;
        private Iterator<Map<String, AttributeValue>> pageIter = Collections.emptyListIterator();

        public ScanAllObjectsIterator(Set<ObjType> returnedObjTypes) {
            AttributeValue[] objTypes = (AttributeValue[])returnedObjTypes.stream().map(ObjType::shortName).map(AttributeValue::fromS).toArray(AttributeValue[]::new);
            HashMap<String, Condition> scanFilter = new HashMap<String, Condition>();
            scanFilter.put("k", DynamoDBBackend.condition(ComparisonOperator.BEGINS_WITH, AttributeValue.fromS((String)DynamoDBPersist.this.keyPrefix)));
            scanFilter.put("y", DynamoDBBackend.condition(ComparisonOperator.IN, objTypes));
            this.iter = DynamoDBPersist.this.backend.client().scanPaginator(b -> b.tableName(DynamoDBPersist.this.backend.tableObjs).scanFilter(scanFilter)).iterator();
        }

        protected Obj computeNext() {
            while (!this.pageIter.hasNext()) {
                if (!this.iter.hasNext()) {
                    return (Obj)this.endOfData();
                }
                ScanResponse r = this.iter.next();
                this.pageIter = r.items().iterator();
            }
            Map<String, AttributeValue> item = this.pageIter.next();
            return DynamoDBPersist.this.decomposeObj(item);
        }

        public void close() {
        }
    }

    private static abstract class StoreObjDesc<O extends Obj> {
        final String typeName;

        StoreObjDesc(String typeName) {
            this.typeName = typeName;
        }

        abstract void toMap(O var1, Map<String, AttributeValue> var2, int var3, int var4) throws ObjTooLargeException;

        abstract O fromMap(ObjId var1, Map<String, AttributeValue> var2);
    }
}

