/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb;

import java.net.URI;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.dynamodb.ImmutableDynamoClientProducer;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;

@Value.Immutable
public abstract class DynamoClientProducer {
    public static ImmutableDynamoClientProducer.Builder builder() {
        return ImmutableDynamoClientProducer.builder();
    }

    abstract String endpointURI();

    abstract String region();

    abstract AwsCredentialsProvider credentialsProvider();

    public DynamoDbClient createClient() {
        String endpointURI;
        DynamoDbClientBuilder clientBuilder = (DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().httpClientBuilder((SdkHttpClient.Builder)ApacheHttpClient.builder())).region(Region.of((String)this.region()));
        AwsCredentialsProvider credentialsProvider = this.credentialsProvider();
        if (credentialsProvider != null) {
            clientBuilder = (DynamoDbClientBuilder)clientBuilder.credentialsProvider(credentialsProvider);
        }
        if ((endpointURI = this.endpointURI()) != null) {
            clientBuilder = (DynamoDbClientBuilder)clientBuilder.endpointOverride(URI.create(endpointURI));
        }
        return (DynamoDbClient)clientBuilder.build();
    }
}

