/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.function.Consumer;
import org.projectnessie.versioned.storage.dynamodb.DynamoClientProducer;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBBackend;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBBackendConfig;
import org.projectnessie.versioned.storage.dynamodb.ImmutableDynamoDBBackendConfig;
import org.projectnessie.versioned.storage.testextension.BackendTestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

public class DynamoDBBackendTestFactory
implements BackendTestFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoDBBackendTestFactory.class);
    public static final int DYNAMODB_PORT = 8000;
    private GenericContainer<?> container;
    private String endpointURI;

    public String getName() {
        return "DynamoDB";
    }

    public DynamoDBBackend createNewBackend() {
        return this.createNewBackend(this.dynamoDBConfigBuilder().build(), true);
    }

    public DynamoDBBackend createNewBackend(DynamoDBBackendConfig dynamoDBBackendConfig, boolean closeClient) {
        return new DynamoDBBackend(dynamoDBBackendConfig, closeClient);
    }

    @VisibleForTesting
    public ImmutableDynamoDBBackendConfig.Builder dynamoDBConfigBuilder() {
        return DynamoDBBackendConfig.builder().client(this.buildNewClient());
    }

    @VisibleForTesting
    DynamoDbClient buildNewClient() {
        return DynamoClientProducer.builder().endpointURI(this.endpointURI).region("US_WEST_2").credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"xxx", (String)"xxx"))).build().createClient();
    }

    public void startDynamo(Optional<String> containerNetworkId) {
        if (this.container != null) {
            throw new IllegalStateException("Already started");
        }
        String version = System.getProperty("it.nessie.container.dynamodb-local.tag", "latest");
        String imageName = "amazon/dynamodb-local:" + version;
        int retry = 0;
        while (true) {
            GenericContainer c = new GenericContainer(imageName).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).withExposedPorts(new Integer[]{8000}).withCommand(new String[]{"-jar", "DynamoDBLocal.jar", "-inMemory", "-sharedDb"});
            containerNetworkId.ifPresent(arg_0 -> ((GenericContainer)c).withNetworkMode(arg_0));
            try {
                c.start();
                this.container = c;
            }
            catch (ContainerLaunchException e) {
                c.close();
                if (e.getCause() == null || retry >= 3) {
                    LOGGER.error("Launch of container {} failed", (Object)c.getDockerImageName(), (Object)e);
                    throw new RuntimeException(e);
                }
                LOGGER.warn("Launch of container {} failed, will retry...", (Object)c.getDockerImageName(), (Object)e);
                ++retry;
                continue;
            }
            break;
        }
        Integer port = containerNetworkId.isPresent() ? 8000 : this.container.getFirstMappedPort();
        String host = containerNetworkId.isPresent() ? this.container.getCurrentContainerInfo().getConfig().getHostName() : this.container.getHost();
        this.endpointURI = String.format("http://%s:%d", host, port);
    }

    public void start() {
        this.startDynamo(Optional.empty());
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        finally {
            this.container = null;
        }
    }

    public String getEndpointURI() {
        return this.endpointURI;
    }
}

