/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb.serializers;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBSerde;
import org.projectnessie.versioned.storage.dynamodb.serializers.ObjSerializer;
import org.projectnessie.versioned.storage.serialize.SmileSerialization;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class CustomObjSerializer
implements ObjSerializer<Obj> {
    public static final ObjSerializer<?> INSTANCE = new CustomObjSerializer();
    private static final String COL_CUSTOM = "x";
    private static final String COL_CUSTOM_CLASS = "xc";
    private static final String COL_CUSTOM_DATA = "xd";
    private static final String COL_CUSTOM_COMPRESSION = "xC";

    private CustomObjSerializer() {
    }

    @Override
    public String attributeName() {
        return COL_CUSTOM;
    }

    @Override
    public void toMap(Obj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) throws ObjTooLargeException {
        i.put(COL_CUSTOM_CLASS, AttributeValue.fromS((String)obj.type().targetClass().getName()));
        DynamoDBSerde.bytesAttribute(i, COL_CUSTOM_DATA, ByteString.copyFrom((byte[])SmileSerialization.serializeObj((Obj)obj, compression -> i.put(COL_CUSTOM_COMPRESSION, AttributeValue.fromS((String)compression.valueString())))));
    }

    @Override
    public Obj fromMap(ObjId id, Map<String, AttributeValue> i) {
        ByteBuffer buffer = Objects.requireNonNull(DynamoDBSerde.attributeToBytes(i, COL_CUSTOM_DATA)).asReadOnlyByteBuffer();
        return SmileSerialization.deserializeObj((ObjId)id, (ByteBuffer)buffer, (String)DynamoDBSerde.attributeToString(i, COL_CUSTOM_CLASS), (String)DynamoDBSerde.attributeToString(i, COL_CUSTOM_COMPRESSION));
    }
}

