/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb.serializers;

import java.util.Map;
import org.projectnessie.versioned.storage.common.objtypes.RefObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBSerde;
import org.projectnessie.versioned.storage.dynamodb.serializers.ObjSerializer;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class RefObjSerializer
implements ObjSerializer<RefObj> {
    public static final RefObjSerializer INSTANCE = new RefObjSerializer();
    private static final String COL_REF = "e";
    private static final String COL_REF_NAME = "n";
    private static final String COL_REF_INITIAL_POINTER = "p";
    private static final String COL_REF_CREATED_AT = "c";
    private static final String COL_REF_EXTENDED_INFO = "e";

    private RefObjSerializer() {
    }

    @Override
    public String attributeName() {
        return "e";
    }

    @Override
    public void toMap(RefObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) {
        i.put(COL_REF_NAME, AttributeValue.fromS((String)obj.name()));
        i.put(COL_REF_CREATED_AT, AttributeValue.fromS((String)Long.toString(obj.createdAtMicros())));
        DynamoDBSerde.objIdToAttribute(i, COL_REF_INITIAL_POINTER, obj.initialPointer());
        ObjId extendedInfoObj = obj.extendedInfoObj();
        if (extendedInfoObj != null) {
            DynamoDBSerde.objIdToAttribute(i, "e", extendedInfoObj);
        }
    }

    @Override
    public RefObj fromMap(ObjId id, Map<String, AttributeValue> i) {
        String createdAtStr = DynamoDBSerde.attributeToString(i, COL_REF_CREATED_AT);
        long createdAt = createdAtStr != null ? Long.parseLong(createdAtStr) : 0L;
        return RefObj.ref((ObjId)id, (String)DynamoDBSerde.attributeToString(i, COL_REF_NAME), (ObjId)DynamoDBSerde.attributeToObjId(i, COL_REF_INITIAL_POINTER), (long)createdAt, (ObjId)DynamoDBSerde.attributeToObjId(i, "e"));
    }
}

