/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb.serializers;

import java.util.Map;
import java.util.Objects;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.ContentValueObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBSerde;
import org.projectnessie.versioned.storage.dynamodb.serializers.ObjSerializer;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class ContentValueObjSerializer
implements ObjSerializer<ContentValueObj> {
    public static final ContentValueObjSerializer INSTANCE = new ContentValueObjSerializer();
    private static final String COL_VALUE = "v";
    private static final String COL_VALUE_CONTENT_ID = "i";
    private static final String COL_VALUE_PAYLOAD = "p";
    private static final String COL_VALUE_DATA = "d";

    private ContentValueObjSerializer() {
    }

    @Override
    public String attributeName() {
        return COL_VALUE;
    }

    @Override
    public void toMap(ContentValueObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) {
        i.put(COL_VALUE_CONTENT_ID, AttributeValue.fromS((String)obj.contentId()));
        i.put(COL_VALUE_PAYLOAD, AttributeValue.fromS((String)Integer.toString(obj.payload())));
        DynamoDBSerde.bytesAttribute(i, COL_VALUE_DATA, obj.data());
    }

    @Override
    public ContentValueObj fromMap(ObjId id, ObjType type, Map<String, AttributeValue> i) {
        return ContentValueObj.contentValue((ObjId)id, (String)DynamoDBSerde.attributeToString(i, COL_VALUE_CONTENT_ID), (int)Integer.parseInt(Objects.requireNonNull(DynamoDBSerde.attributeToString(i, COL_VALUE_PAYLOAD))), (ByteString)DynamoDBSerde.attributeToBytes(i, COL_VALUE_DATA));
    }
}

