/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb.serializers;

import java.util.Map;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.UniqueIdObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBSerde;
import org.projectnessie.versioned.storage.dynamodb.serializers.ObjSerializer;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class UniqueIdObjSerializer
implements ObjSerializer<UniqueIdObj> {
    public static final UniqueIdObjSerializer INSTANCE = new UniqueIdObjSerializer();
    private static final String COL_UNIQUE = "u";
    static final String COL_UNIQUE_SPACE = "s";
    static final String COL_UNIQUE_VALUE = "v";

    private UniqueIdObjSerializer() {
    }

    @Override
    public String attributeName() {
        return COL_UNIQUE;
    }

    @Override
    public void toMap(UniqueIdObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) {
        i.put(COL_UNIQUE_SPACE, AttributeValue.fromS((String)obj.space()));
        DynamoDBSerde.bytesAttribute(i, COL_UNIQUE_VALUE, obj.value());
    }

    @Override
    public UniqueIdObj fromMap(ObjId id, ObjType type, Map<String, AttributeValue> i) {
        return UniqueIdObj.uniqueId((ObjId)id, (String)DynamoDBSerde.attributeToString(i, COL_UNIQUE_SPACE), (ByteString)DynamoDBSerde.attributeToBytes(i, COL_UNIQUE_VALUE));
    }
}

