/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb.serializers;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.TagObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBSerde;
import org.projectnessie.versioned.storage.dynamodb.serializers.ObjSerializer;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class TagObjSerializer
implements ObjSerializer<TagObj> {
    public static final TagObjSerializer INSTANCE = new TagObjSerializer();
    private static final String COL_TAG = "t";
    private static final String COL_TAG_MESSAGE = "m";
    private static final String COL_TAG_HEADERS = "h";
    private static final String COL_TAG_SIGNATURE = "s";

    private TagObjSerializer() {
    }

    @Override
    public String attributeName() {
        return COL_TAG;
    }

    @Override
    public void toMap(TagObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) {
        ByteString signature;
        String message = obj.message();
        if (message != null) {
            i.put(COL_TAG_MESSAGE, AttributeValue.fromS((String)message));
        }
        HashMap<String, AttributeValue> headerMap = new HashMap<String, AttributeValue>();
        CommitHeaders headers = obj.headers();
        if (headers != null) {
            for (String s : headers.keySet()) {
                headerMap.put(s, AttributeValue.fromL(headers.getAll(s).stream().map(AttributeValue::fromS).collect(Collectors.toList())));
            }
            if (!headerMap.isEmpty()) {
                i.put(COL_TAG_HEADERS, AttributeValue.fromM(headerMap));
            }
        }
        if ((signature = obj.signature()) != null) {
            DynamoDBSerde.bytesAttribute(i, COL_TAG_SIGNATURE, signature);
        }
    }

    @Override
    public TagObj fromMap(ObjId id, ObjType type, Map<String, AttributeValue> i, String versionToken) {
        CommitHeaders tagHeaders = null;
        AttributeValue headerMap = i.get(COL_TAG_HEADERS);
        if (headerMap != null) {
            CommitHeaders.Builder headers = CommitHeaders.newCommitHeaders();
            headerMap.m().forEach((k, l) -> l.l().forEach(hv -> headers.add(k, hv.s())));
            tagHeaders = headers.build();
        }
        return TagObj.tag((ObjId)id, (String)DynamoDBSerde.attributeToString(i, COL_TAG_MESSAGE), tagHeaders, (ByteString)DynamoDBSerde.attributeToBytes(i, COL_TAG_SIGNATURE));
    }
}

