/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.agrona.collections.Object2IntHashMap;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.UnknownOperationResultException;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.ObjTypes;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.common.persist.UpdateableObj;
import org.projectnessie.versioned.storage.dynamodb.BatchWrite;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBBackend;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBSerde;
import org.projectnessie.versioned.storage.dynamodb.serializers.ObjSerializer;
import org.projectnessie.versioned.storage.dynamodb.serializers.ObjSerializers;
import org.projectnessie.versioned.storage.serialize.ProtoSerialization;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.AbortedException;
import software.amazon.awssdk.core.exception.ApiCallAttemptTimeoutException;
import software.amazon.awssdk.core.exception.ApiCallTimeoutException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class DynamoDBPersist
implements Persist {
    private final DynamoDBBackend backend;
    private final StoreConfig config;
    private final String keyPrefix;

    DynamoDBPersist(DynamoDBBackend backend, StoreConfig config) {
        this.backend = backend;
        this.config = config;
        this.keyPrefix = DynamoDBBackend.keyPrefix(config.repositoryId());
    }

    @Nonnull
    public String name() {
        return "DynamoDB";
    }

    public int hardObjectSizeLimit() {
        return 409600;
    }

    @Nonnull
    public StoreConfig config() {
        return this.config;
    }

    @Nonnull
    public Reference addReference(@Nonnull Reference reference) throws RefAlreadyExistsException {
        Preconditions.checkArgument((!reference.deleted() ? 1 : 0) != 0, (Object)"Deleted references must not be added");
        try {
            this.backend.client().putItem(b -> b.tableName(this.backend.tableRefs).conditionExpression("attribute_not_exists(p)").item(this.referenceAttributeValues(reference)));
            return reference;
        }
        catch (ConditionalCheckFailedException e) {
            throw new RefAlreadyExistsException(this.fetchReference(reference.name()));
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
    }

    @Nonnull
    public Reference markReferenceAsDeleted(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        try {
            reference = reference.withDeleted(false);
            Reference asDeleted = reference.withDeleted(true);
            this.conditionalReferencePut(asDeleted, reference);
            return asDeleted;
        }
        catch (ConditionalCheckFailedException e) {
            Reference r = this.fetchReference(reference.name());
            if (r == null) {
                throw new RefNotFoundException(reference.name());
            }
            throw new RefConditionFailedException(r);
        }
    }

    @Nonnull
    public Reference updateReferencePointer(@Nonnull Reference reference, @Nonnull ObjId newPointer) throws RefNotFoundException, RefConditionFailedException {
        try {
            reference = reference.withDeleted(false);
            Reference bumpedReference = reference.forNewPointer(newPointer, this.config);
            this.conditionalReferencePut(bumpedReference, reference);
            return bumpedReference;
        }
        catch (ConditionalCheckFailedException e) {
            Reference r = this.fetchReference(reference.name());
            if (r == null) {
                throw new RefNotFoundException(reference.name());
            }
            throw new RefConditionFailedException(r);
        }
    }

    public void purgeReference(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        reference = reference.withDeleted(true);
        String condition = DynamoDBPersist.referenceCondition(reference);
        Map<String, AttributeValue> values = DynamoDBPersist.referenceConditionAttributes(reference);
        String refName = reference.name();
        try {
            this.backend.client().deleteItem(b -> b.tableName(this.backend.tableRefs).key(this.referenceKeyMap(refName)).expressionAttributeValues(values).conditionExpression(condition));
        }
        catch (ConditionalCheckFailedException e) {
            Reference r = this.fetchReference(refName);
            if (r == null) {
                throw new RefNotFoundException(refName);
            }
            throw new RefConditionFailedException(r);
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
    }

    @Nullable
    public Reference fetchReference(@Nonnull String name) {
        GetItemResponse item;
        try {
            item = this.backend.client().getItem(b -> b.tableName(this.backend.tableRefs).key(this.referenceKeyMap(name)));
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
        if (!item.hasItem()) {
            return null;
        }
        Map i = item.item();
        String createdAtStr = DynamoDBSerde.attributeToString(i, "c");
        long createdAt = createdAtStr != null ? Long.parseLong(createdAtStr) : 0L;
        return Reference.reference((String)name, (ObjId)DynamoDBSerde.attributeToObjId(i, "p"), (boolean)DynamoDBSerde.attributeToBool(i, "d"), (long)createdAt, (ObjId)DynamoDBSerde.attributeToObjId(i, "e"), this.attributeToPreviousPointers(i));
    }

    @Nonnull
    public Reference[] fetchReferences(@Nonnull String[] names) {
        ArrayList<Map<String, AttributeValue>> keys = new ArrayList<Map<String, AttributeValue>>(Math.min(names.length, 100));
        Object2IntHashMap nameToIndex = new Object2IntHashMap(200, 0.65f, -1);
        Reference[] r = new Reference[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name == null) continue;
            keys.add(this.referenceKeyMap(name));
            nameToIndex.put((Object)name, i);
            if (keys.size() != 100) continue;
            this.findReferencesPage(r, keys, (Object2IntHashMap<String>)nameToIndex);
            keys.clear();
            nameToIndex.clear();
        }
        if (!keys.isEmpty()) {
            this.findReferencesPage(r, keys, (Object2IntHashMap<String>)nameToIndex);
        }
        return r;
    }

    private void findReferencesPage(Reference[] r, List<Map<String, AttributeValue>> keys, Object2IntHashMap<String> nameToIndex) {
        Map<String, KeysAndAttributes> requestItems = Collections.singletonMap(this.backend.tableRefs, (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).build());
        try {
            BatchGetItemResponse response = this.backend.client().batchGetItem(b -> b.requestItems(requestItems));
            ((List)response.responses().get(this.backend.tableRefs)).forEach(item -> {
                String name = ((AttributeValue)item.get("k")).s().substring(this.keyPrefix.length());
                String createdAtStr = DynamoDBSerde.attributeToString(item, "c");
                long createdAt = createdAtStr != null ? Long.parseLong(createdAtStr) : 0L;
                Reference reference = Reference.reference((String)name, (ObjId)DynamoDBSerde.attributeToObjId(item, "p"), (boolean)DynamoDBSerde.attributeToBool(item, "d"), (long)createdAt, (ObjId)DynamoDBSerde.attributeToObjId(item, "e"), this.attributeToPreviousPointers((Map<String, AttributeValue>)item));
                int idx = nameToIndex.getValue((Object)name);
                if (idx >= 0) {
                    r[idx] = reference;
                }
            });
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
    }

    private List<Reference.PreviousPointer> attributeToPreviousPointers(Map<String, AttributeValue> item) {
        AttributeValue attr = item.get("h");
        if (attr == null) {
            return Collections.emptyList();
        }
        return ProtoSerialization.deserializePreviousPointers((byte[])attr.b().asByteArray());
    }

    @Nonnull
    public Obj fetchObj(@Nonnull ObjId id) throws ObjNotFoundException {
        GetItemResponse item;
        try {
            item = this.backend.client().getItem(b -> b.tableName(this.backend.tableObjs).key(this.objKeyMap(id)));
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
        if (!item.hasItem()) {
            throw new ObjNotFoundException(id);
        }
        return this.itemToObj(item.item());
    }

    @Nonnull
    public <T extends Obj> T fetchTypedObj(@Nonnull ObjId id, ObjType type, Class<T> typeClass) throws ObjNotFoundException {
        GetItemResponse item;
        try {
            item = this.backend.client().getItem(b -> b.tableName(this.backend.tableObjs).key(this.objKeyMap(id)));
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
        if (!item.hasItem()) {
            throw new ObjNotFoundException(id);
        }
        Obj obj = this.itemToObj(item.item());
        if (!obj.type().equals(type)) {
            throw new ObjNotFoundException(id);
        }
        Obj r = obj;
        return (T)r;
    }

    @Nonnull
    public ObjType fetchObjType(@Nonnull ObjId id) throws ObjNotFoundException {
        GetItemResponse item;
        try {
            item = this.backend.client().getItem(b -> b.tableName(this.backend.tableObjs).key(this.objKeyMap(id)).attributesToGet(new String[]{"y"}));
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
        if (!item.hasItem()) {
            throw new ObjNotFoundException(id);
        }
        return ObjTypes.forShortName((String)((AttributeValue)item.item().get("y")).s());
    }

    @Nonnull
    public Obj[] fetchObjs(@Nonnull ObjId[] ids) throws ObjNotFoundException {
        ArrayList<Map<String, AttributeValue>> keys = new ArrayList<Map<String, AttributeValue>>(Math.min(ids.length, 100));
        Object2IntHashMap idToIndex = new Object2IntHashMap(200, 0.65f, -1);
        Obj[] r = new Obj[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            ObjId id = ids[i];
            if (id == null) continue;
            keys.add(this.objKeyMap(id));
            idToIndex.put((Object)id, i);
            if (keys.size() != 100) continue;
            this.fetchObjsPage(r, keys, (Object2IntHashMap<ObjId>)idToIndex);
            keys.clear();
            idToIndex.clear();
        }
        if (!keys.isEmpty()) {
            this.fetchObjsPage(r, keys, (Object2IntHashMap<ObjId>)idToIndex);
        }
        ArrayList<ObjId> notFound = null;
        for (int i = 0; i < ids.length; ++i) {
            ObjId id = ids[i];
            if (id == null || r[i] != null) continue;
            if (notFound == null) {
                notFound = new ArrayList<ObjId>();
            }
            notFound.add(id);
        }
        if (notFound != null) {
            throw new ObjNotFoundException(notFound);
        }
        return r;
    }

    private void fetchObjsPage(Obj[] r, List<Map<String, AttributeValue>> keys, Object2IntHashMap<ObjId> idToIndex) {
        Map<String, KeysAndAttributes> requestItems = Collections.singletonMap(this.backend.tableObjs, (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).build());
        try {
            BatchGetItemResponse response = this.backend.client().batchGetItem(b -> b.requestItems(requestItems));
            ((List)response.responses().get(this.backend.tableObjs)).forEach(item -> {
                Obj obj = this.itemToObj((Map<String, AttributeValue>)item);
                int idx = idToIndex.getValue((Object)obj.id());
                if (idx != -1) {
                    r[idx] = obj;
                }
            });
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
    }

    @Nonnull
    public boolean[] storeObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        boolean[] r = new boolean[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            Obj o = objs[i];
            if (o == null) continue;
            r[i] = this.storeObj(o);
        }
        return r;
    }

    public boolean storeObj(@Nonnull Obj obj, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        ObjId id = obj.id();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
        Map<String, AttributeValue> item = this.objToItem(obj, id, ignoreSoftSizeRestrictions);
        try {
            this.backend.client().putItem(b -> b.tableName(this.backend.tableObjs).conditionExpression("attribute_not_exists(y)").item(item));
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
        catch (DynamoDbException e) {
            AwsErrorDetails errorDetails = e.awsErrorDetails();
            if (DynamoDBPersist.checkItemSizeExceeded(errorDetails)) {
                throw new ObjTooLargeException();
            }
            throw DynamoDBPersist.unhandledException((RuntimeException)((Object)e));
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
        return true;
    }

    public void deleteObj(@Nonnull ObjId id) {
        this.backend.client().deleteItem(b -> b.tableName(this.backend.tableObjs).key(this.objKeyMap(id)));
    }

    public void deleteObjs(@Nonnull ObjId[] ids) {
        try (BatchWrite batchWrite = new BatchWrite(this.backend, this.backend.tableObjs);){
            for (ObjId id : ids) {
                if (id == null) continue;
                batchWrite.addDelete(this.objKey(id));
            }
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
    }

    public void upsertObj(@Nonnull Obj obj) throws ObjTooLargeException {
        ObjId id = obj.id();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
        Map<String, AttributeValue> item = this.objToItem(obj, id, false);
        try {
            this.backend.client().putItem(b -> b.tableName(this.backend.tableObjs).item(item));
        }
        catch (DynamoDbException e) {
            AwsErrorDetails errorDetails = e.awsErrorDetails();
            if (DynamoDBPersist.checkItemSizeExceeded(errorDetails)) {
                throw new ObjTooLargeException();
            }
            throw DynamoDBPersist.unhandledException((RuntimeException)((Object)e));
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
    }

    public void upsertObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        try (BatchWrite batchWrite = new BatchWrite(this.backend, this.backend.tableObjs);){
            for (Obj obj : objs) {
                if (obj == null) continue;
                ObjId id = obj.id();
                Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
                Map<String, AttributeValue> item = this.objToItem(obj, id, false);
                batchWrite.addPut(item);
            }
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
    }

    public boolean deleteConditional(@Nonnull UpdateableObj obj) {
        ObjId id = obj.id();
        Map<String, ExpectedAttributeValue> expectedValues = DynamoDBPersist.conditionalUpdateExpectedValues(obj);
        try {
            this.backend.client().deleteItem(b -> b.tableName(this.backend.tableObjs).key(this.objKeyMap(id)).expected(expectedValues));
            return true;
        }
        catch (ConditionalCheckFailedException checkFailedException) {
            return false;
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
    }

    public boolean updateConditional(@Nonnull UpdateableObj expected, @Nonnull UpdateableObj newValue) throws ObjTooLargeException {
        ObjId id = expected.id();
        Preconditions.checkArgument((id != null && id.equals(newValue.id()) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)expected.type().equals(newValue.type()));
        Preconditions.checkArgument((!expected.versionToken().equals(newValue.versionToken()) ? 1 : 0) != 0);
        Map<String, ExpectedAttributeValue> expectedValues = DynamoDBPersist.conditionalUpdateExpectedValues(expected);
        Map<String, AttributeValueUpdate> updates = this.objToItem((Obj)newValue, id, false).entrySet().stream().filter(e -> !"y".equals(e.getKey()) && !"k".equals(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> (AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)e.getValue()).build()));
        try {
            this.backend.client().updateItem(b -> b.tableName(this.backend.tableObjs).key(this.objKeyMap(id)).attributeUpdates(updates).expected(expectedValues));
            return true;
        }
        catch (ConditionalCheckFailedException checkFailedException) {
            return false;
        }
        catch (RuntimeException e2) {
            throw DynamoDBPersist.unhandledException(e2);
        }
    }

    private static Map<String, ExpectedAttributeValue> conditionalUpdateExpectedValues(UpdateableObj expected) {
        HashMap<String, ExpectedAttributeValue> expectedValues = new HashMap<String, ExpectedAttributeValue>();
        expectedValues.put("y", (ExpectedAttributeValue)ExpectedAttributeValue.builder().value(AttributeValue.fromS((String)expected.type().shortName())).build());
        expectedValues.put("V", (ExpectedAttributeValue)ExpectedAttributeValue.builder().value(AttributeValue.fromS((String)expected.versionToken())).build());
        return expectedValues;
    }

    @Nonnull
    public CloseableIterator<Obj> scanAllObjects(@Nonnull Set<ObjType> returnedObjTypes) {
        return new ScanAllObjectsIterator(returnedObjTypes);
    }

    public void erase() {
        this.backend.eraseRepositories(Collections.singleton(this.config().repositoryId()));
    }

    private Obj itemToObj(Map<String, AttributeValue> item) {
        ObjId id = ObjId.objIdFromString((String)item.get("k").s().substring(this.keyPrefix.length()));
        AttributeValue attributeValue = item.get("y");
        ObjType type = ObjTypes.forShortName((String)attributeValue.s());
        ObjSerializer<Obj> serializer = ObjSerializers.forType(type);
        Map inner = item.get(serializer.attributeName()).m();
        String versionToken = DynamoDBSerde.attributeToString(item, "V");
        return serializer.fromMap(id, type, inner, versionToken);
    }

    @Nonnull
    private Map<String, AttributeValue> objToItem(@Nonnull Obj obj, ObjId id, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        ObjType type = obj.type();
        ObjSerializer<Obj> serializer = ObjSerializers.forType(type);
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        HashMap<String, AttributeValue> inner = new HashMap<String, AttributeValue>();
        item.put("k", this.objKey(id));
        item.put("y", AttributeValue.fromS((String)type.shortName()));
        if (obj instanceof UpdateableObj) {
            item.put("V", AttributeValue.fromS((String)((UpdateableObj)obj).versionToken()));
        }
        int incrementalIndexSizeLimit = ignoreSoftSizeRestrictions ? Integer.MAX_VALUE : this.effectiveIncrementalIndexSizeLimit();
        int indexSizeLimit = ignoreSoftSizeRestrictions ? Integer.MAX_VALUE : this.effectiveIndexSegmentSizeLimit();
        serializer.toMap(obj, inner, incrementalIndexSizeLimit, indexSizeLimit);
        item.put(serializer.attributeName(), AttributeValue.fromM(inner));
        return item;
    }

    private static boolean checkItemSizeExceeded(AwsErrorDetails errorDetails) {
        return "DynamoDb".equals(errorDetails.serviceName()) && "ValidationException".equals(errorDetails.errorCode()) && errorDetails.errorMessage().toLowerCase(Locale.ROOT).contains("item size");
    }

    @Nonnull
    private Map<String, AttributeValue> referenceAttributeValues(@Nonnull Reference reference) {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put("k", this.referenceKey(reference.name()));
        DynamoDBSerde.objIdToAttribute(item, "p", reference.pointer());
        item.put("d", AttributeValue.fromBool((Boolean)reference.deleted()));
        item.put("c", DynamoDBPersist.referencesCreatedAt(reference));
        DynamoDBSerde.objIdToAttribute(item, "e", reference.extendedInfoObj());
        byte[] previousPointers = ProtoSerialization.serializePreviousPointers((List)reference.previousPointers());
        if (previousPointers != null) {
            item.put("h", AttributeValue.fromB((SdkBytes)SdkBytes.fromByteArray((byte[])previousPointers)));
        }
        return item;
    }

    private void conditionalReferencePut(@Nonnull Reference reference, Reference expected) {
        String condition = DynamoDBPersist.referenceCondition(expected);
        Map<String, AttributeValue> values = DynamoDBPersist.referenceConditionAttributes(expected);
        try {
            this.backend.client().putItem(b -> b.tableName(this.backend.tableRefs).conditionExpression(condition).expressionAttributeValues(values).item(this.referenceAttributeValues(reference)));
        }
        catch (RuntimeException e) {
            throw DynamoDBPersist.unhandledException(e);
        }
    }

    private static Map<String, AttributeValue> referenceConditionAttributes(Reference reference) {
        HashMap<String, AttributeValue> values = new HashMap<String, AttributeValue>();
        DynamoDBSerde.objIdToAttribute(values, ":pointer", reference.pointer());
        values.put(":deleted", AttributeValue.fromBool((Boolean)reference.deleted()));
        values.put(":createdAt", DynamoDBPersist.referencesCreatedAt(reference));
        DynamoDBSerde.objIdToAttribute(values, ":extendedInfo", reference.extendedInfoObj());
        return values;
    }

    private static String referenceCondition(Reference reference) {
        return "(d = :deleted) AND (p = :pointer)" + (reference.createdAtMicros() != 0L ? " AND (c = :createdAt)" : " AND attribute_not_exists(c)") + (reference.extendedInfoObj() != null ? " AND (e = :extendedInfo)" : " AND attribute_not_exists(e)");
    }

    private static AttributeValue referencesCreatedAt(Reference reference) {
        long createdAt = reference.createdAtMicros();
        return createdAt == 0L ? null : AttributeValue.fromS((String)Long.toString(createdAt));
    }

    @Nonnull
    private AttributeValue referenceKey(@Nonnull String reference) {
        return AttributeValue.fromS((String)(this.keyPrefix + reference));
    }

    @Nonnull
    private Map<String, AttributeValue> referenceKeyMap(@Nonnull String reference) {
        return Collections.singletonMap("k", this.referenceKey(reference));
    }

    @Nonnull
    private AttributeValue objKey(@Nonnull ObjId id) {
        return AttributeValue.fromS((String)(this.keyPrefix + id));
    }

    @Nonnull
    private Map<String, AttributeValue> objKeyMap(@Nonnull ObjId id) {
        return Collections.singletonMap("k", this.objKey(id));
    }

    static RuntimeException unhandledException(RuntimeException e) {
        if (e instanceof SdkException && (((SdkException)e).retryable() || e instanceof ApiCallTimeoutException || e instanceof ApiCallAttemptTimeoutException || e instanceof AbortedException)) {
            return new UnknownOperationResultException((Throwable)e);
        }
        if (e instanceof AwsServiceException && ((AwsServiceException)e).isThrottlingException()) {
            return new UnknownOperationResultException((Throwable)e);
        }
        return e;
    }

    private class ScanAllObjectsIterator
    extends AbstractIterator<Obj>
    implements CloseableIterator<Obj> {
        private final Iterator<ScanResponse> iter;
        private Iterator<Map<String, AttributeValue>> pageIter = Collections.emptyListIterator();

        public ScanAllObjectsIterator(Set<ObjType> returnedObjTypes) {
            AttributeValue[] objTypes = (AttributeValue[])returnedObjTypes.stream().map(ObjType::shortName).map(AttributeValue::fromS).toArray(AttributeValue[]::new);
            HashMap<String, Condition> scanFilter = new HashMap<String, Condition>();
            scanFilter.put("k", DynamoDBBackend.condition(ComparisonOperator.BEGINS_WITH, AttributeValue.fromS((String)DynamoDBPersist.this.keyPrefix)));
            scanFilter.put("y", DynamoDBBackend.condition(ComparisonOperator.IN, objTypes));
            try {
                this.iter = DynamoDBPersist.this.backend.client().scanPaginator(b -> b.tableName(DynamoDBPersist.this.backend.tableObjs).scanFilter(scanFilter)).iterator();
            }
            catch (RuntimeException e) {
                throw DynamoDBPersist.unhandledException(e);
            }
        }

        protected Obj computeNext() {
            try {
                while (!this.pageIter.hasNext()) {
                    if (!this.iter.hasNext()) {
                        return (Obj)this.endOfData();
                    }
                    ScanResponse r = this.iter.next();
                    this.pageIter = r.items().iterator();
                }
                Map<String, AttributeValue> item = this.pageIter.next();
                return DynamoDBPersist.this.itemToObj(item);
            }
            catch (RuntimeException e) {
                throw DynamoDBPersist.unhandledException(e);
            }
        }

        public void close() {
        }
    }
}

