/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb.serializers;

import java.util.ArrayList;
import java.util.Map;
import org.projectnessie.versioned.storage.common.objtypes.IndexSegmentsObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBSerde;
import org.projectnessie.versioned.storage.dynamodb.serializers.ObjSerializer;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class IndexSegmentsObjSerializer
implements ObjSerializer<IndexSegmentsObj> {
    public static final IndexSegmentsObjSerializer INSTANCE = new IndexSegmentsObjSerializer();
    private static final String COL_SEGMENTS = "I";
    private static final String COL_SEGMENTS_STRIPES = "s";

    private IndexSegmentsObjSerializer() {
    }

    @Override
    public String attributeName() {
        return COL_SEGMENTS;
    }

    @Override
    public void toMap(IndexSegmentsObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) {
        i.put(COL_SEGMENTS_STRIPES, DynamoDBSerde.stripesAttrList(obj.stripes()));
    }

    @Override
    public IndexSegmentsObj fromMap(ObjId id, ObjType type, Map<String, AttributeValue> i, String versionToken) {
        ArrayList stripes = new ArrayList();
        DynamoDBSerde.fromStripesAttrList(i.get(COL_SEGMENTS_STRIPES), stripes::add);
        return IndexSegmentsObj.indexSegments((ObjId)id, stripes);
    }
}

