/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb.serializers;

import java.util.Map;
import java.util.Objects;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.objtypes.IndexObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBSerde;
import org.projectnessie.versioned.storage.dynamodb.serializers.ObjSerializer;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class IndexObjSerializer
implements ObjSerializer<IndexObj> {
    public static final IndexObjSerializer INSTANCE = new IndexObjSerializer();
    private static final String COL_INDEX = "i";
    private static final String COL_INDEX_INDEX = "i";

    private IndexObjSerializer() {
    }

    @Override
    public String attributeName() {
        return "i";
    }

    @Override
    public void toMap(IndexObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) throws ObjTooLargeException {
        ByteString index = obj.index();
        if (index.size() > maxSerializedIndexSize) {
            throw new ObjTooLargeException(index.size(), maxSerializedIndexSize);
        }
        DynamoDBSerde.bytesAttribute(i, "i", index);
    }

    @Override
    public IndexObj fromMap(ObjId id, ObjType type, Map<String, AttributeValue> i, String versionToken) {
        return IndexObj.index((ObjId)id, (ByteString)Objects.requireNonNull(DynamoDBSerde.attributeToBytes(i, "i")));
    }
}

