/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb.serializers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.dynamodb.DynamoDBSerde;
import org.projectnessie.versioned.storage.dynamodb.serializers.ObjSerializer;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class CommitObjSerializer
implements ObjSerializer<CommitObj> {
    public static final CommitObjSerializer INSTANCE = new CommitObjSerializer();
    private static final String COL_COMMIT = "c";
    private static final String COL_COMMIT_CREATED = "c";
    private static final String COL_COMMIT_SEQ = "q";
    private static final String COL_COMMIT_MESSAGE = "m";
    private static final String COL_COMMIT_HEADERS = "h";
    private static final String COL_COMMIT_REFERENCE_INDEX = "x";
    private static final String COL_COMMIT_REFERENCE_INDEX_STRIPES = "r";
    private static final String COL_COMMIT_TAIL = "t";
    private static final String COL_COMMIT_SECONDARY_PARENTS = "s";
    private static final String COL_COMMIT_INCREMENTAL_INDEX = "i";
    private static final String COL_COMMIT_INCOMPLETE_INDEX = "n";
    private static final String COL_COMMIT_TYPE = "y";

    private CommitObjSerializer() {
    }

    @Override
    public String attributeName() {
        return "c";
    }

    @Override
    public void toMap(CommitObj obj, Map<String, AttributeValue> i, int incrementalIndexSize, int maxSerializedIndexSize) throws ObjTooLargeException {
        i.put(COL_COMMIT_SEQ, AttributeValue.fromS((String)Long.toString(obj.seq())));
        i.put("c", AttributeValue.fromS((String)Long.toString(obj.created())));
        ObjId referenceIndex = obj.referenceIndex();
        if (referenceIndex != null) {
            DynamoDBSerde.objIdToAttribute(i, COL_COMMIT_REFERENCE_INDEX, referenceIndex);
        }
        i.put(COL_COMMIT_MESSAGE, AttributeValue.fromS((String)obj.message()));
        DynamoDBSerde.objIdsAttribute(i, COL_COMMIT_TAIL, obj.tail());
        DynamoDBSerde.objIdsAttribute(i, COL_COMMIT_SECONDARY_PARENTS, obj.secondaryParents());
        ByteString index = obj.incrementalIndex();
        if (index.size() > incrementalIndexSize) {
            throw new ObjTooLargeException(index.size(), incrementalIndexSize);
        }
        DynamoDBSerde.bytesAttribute(i, COL_COMMIT_INCREMENTAL_INDEX, index);
        if (!obj.referenceIndexStripes().isEmpty()) {
            i.put(COL_COMMIT_REFERENCE_INDEX_STRIPES, DynamoDBSerde.stripesAttrList(obj.referenceIndexStripes()));
        }
        HashMap<String, AttributeValue> headerMap = new HashMap<String, AttributeValue>();
        CommitHeaders headers = obj.headers();
        for (String s : headers.keySet()) {
            headerMap.put(s, AttributeValue.fromL(headers.getAll(s).stream().map(AttributeValue::fromS).collect(Collectors.toList())));
        }
        if (!headerMap.isEmpty()) {
            i.put(COL_COMMIT_HEADERS, AttributeValue.fromM(headerMap));
        }
        i.put(COL_COMMIT_INCOMPLETE_INDEX, AttributeValue.fromBool((Boolean)obj.incompleteIndex()));
        i.put(COL_COMMIT_TYPE, AttributeValue.fromS((String)obj.commitType().shortName()));
    }

    @Override
    public CommitObj fromMap(ObjId id, ObjType type, Map<String, AttributeValue> i, String versionToken) {
        CommitObj.Builder b = CommitObj.commitBuilder().id(id).seq(Long.parseLong(Objects.requireNonNull(DynamoDBSerde.attributeToString(i, COL_COMMIT_SEQ)))).created(Long.parseLong(Objects.requireNonNull(DynamoDBSerde.attributeToString(i, "c")))).message(DynamoDBSerde.attributeToString(i, COL_COMMIT_MESSAGE)).incrementalIndex(DynamoDBSerde.attributeToBytes(i, COL_COMMIT_INCREMENTAL_INDEX)).incompleteIndex(DynamoDBSerde.attributeToBool(i, COL_COMMIT_INCOMPLETE_INDEX)).commitType(CommitType.fromShortName((String)DynamoDBSerde.attributeToString(i, COL_COMMIT_TYPE)));
        AttributeValue v = i.get(COL_COMMIT_REFERENCE_INDEX);
        if (v != null) {
            b.referenceIndex(DynamoDBSerde.attributeToObjId(v));
        }
        DynamoDBSerde.fromStripesAttrList(i.get(COL_COMMIT_REFERENCE_INDEX_STRIPES), arg_0 -> ((CommitObj.Builder)b).addReferenceIndexStripes(arg_0));
        DynamoDBSerde.attributeToObjIds(i, COL_COMMIT_TAIL, arg_0 -> ((CommitObj.Builder)b).addTail(arg_0));
        DynamoDBSerde.attributeToObjIds(i, COL_COMMIT_SECONDARY_PARENTS, arg_0 -> ((CommitObj.Builder)b).addSecondaryParents(arg_0));
        CommitHeaders.Builder headers = CommitHeaders.newCommitHeaders();
        AttributeValue headerMap = i.get(COL_COMMIT_HEADERS);
        if (headerMap != null) {
            headerMap.m().forEach((k, l) -> l.l().forEach(hv -> headers.add(k, hv.s())));
        }
        b.headers(headers.build());
        return b.build();
    }
}

