/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb2;

import java.nio.ByteBuffer;
import java.util.Map;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public final class DynamoDB2Serde {
    private DynamoDB2Serde() {
    }

    public static String attributeToString(Map<String, AttributeValue> i, String n) {
        AttributeValue v = i.get(n);
        return v != null ? v.s() : null;
    }

    public static boolean attributeToBool(Map<String, AttributeValue> i, String n) {
        AttributeValue v = i.get(n);
        if (v == null) {
            return false;
        }
        Boolean b = v.bool();
        return b != null && b != false;
    }

    public static ObjId attributeToObjId(Map<String, AttributeValue> i, String n) {
        return DynamoDB2Serde.attributeToObjId(i.get(n));
    }

    public static ObjId attributeToObjId(AttributeValue v) {
        return v == null ? null : ObjId.objIdFromByteBuffer((ByteBuffer)v.b().asByteBuffer());
    }

    public static void objIdToAttribute(Map<String, AttributeValue> i, String n, ObjId id) {
        i.put(n, id != null ? AttributeValue.fromB((SdkBytes)SdkBytes.fromByteBuffer((ByteBuffer)id.asByteBuffer())) : null);
    }
}

