/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb2;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.dynamodb2.DynamoDB2BackendConfig;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DynamoDB2BackendConfig", generator="Immutables")
@Immutable
public final class ImmutableDynamoDB2BackendConfig
implements DynamoDB2BackendConfig {
    private final DynamoDbClient client;
    @Nullable
    private final String tablePrefix;

    private ImmutableDynamoDB2BackendConfig(DynamoDbClient client, @Nullable String tablePrefix) {
        this.client = client;
        this.tablePrefix = tablePrefix;
    }

    @Override
    public DynamoDbClient client() {
        return this.client;
    }

    @Override
    public Optional<String> tablePrefix() {
        return Optional.ofNullable(this.tablePrefix);
    }

    public final ImmutableDynamoDB2BackendConfig withClient(DynamoDbClient value) {
        if (this.client == value) {
            return this;
        }
        DynamoDbClient newValue = Objects.requireNonNull(value, "client");
        return new ImmutableDynamoDB2BackendConfig(newValue, this.tablePrefix);
    }

    public final ImmutableDynamoDB2BackendConfig withTablePrefix(String value) {
        String newValue = Objects.requireNonNull(value, "tablePrefix");
        if (Objects.equals(this.tablePrefix, newValue)) {
            return this;
        }
        return new ImmutableDynamoDB2BackendConfig(this.client, newValue);
    }

    public final ImmutableDynamoDB2BackendConfig withTablePrefix(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tablePrefix, value)) {
            return this;
        }
        return new ImmutableDynamoDB2BackendConfig(this.client, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDynamoDB2BackendConfig && this.equalTo(0, (ImmutableDynamoDB2BackendConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableDynamoDB2BackendConfig another) {
        return this.client.equals((Object)another.client) && Objects.equals(this.tablePrefix, another.tablePrefix);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + Objects.hashCode(this.tablePrefix);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DynamoDB2BackendConfig").omitNullValues().add("client", (Object)this.client).add("tablePrefix", (Object)this.tablePrefix).toString();
    }

    public static ImmutableDynamoDB2BackendConfig copyOf(DynamoDB2BackendConfig instance) {
        if (instance instanceof ImmutableDynamoDB2BackendConfig) {
            return (ImmutableDynamoDB2BackendConfig)instance;
        }
        return ImmutableDynamoDB2BackendConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DynamoDB2BackendConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLIENT = 1L;
        private long initBits = 1L;
        @Nullable
        private DynamoDbClient client;
        @Nullable
        private String tablePrefix;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DynamoDB2BackendConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.client(instance.client());
            Optional<String> tablePrefixOptional = instance.tablePrefix();
            if (tablePrefixOptional.isPresent()) {
                this.tablePrefix(tablePrefixOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(DynamoDbClient client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tablePrefix(String tablePrefix) {
            this.tablePrefix = Objects.requireNonNull(tablePrefix, "tablePrefix");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tablePrefix(Optional<String> tablePrefix) {
            this.tablePrefix = tablePrefix.orElse(null);
            return this;
        }

        public ImmutableDynamoDB2BackendConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDynamoDB2BackendConfig(this.client, this.tablePrefix);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("client");
            }
            return "Cannot build DynamoDB2BackendConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

