/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.dynamodb2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.projectnessie.versioned.storage.dynamodb2.DynamoDB2Backend;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

final class BatchWrite
implements AutoCloseable {
    private final DynamoDB2Backend backend;
    private final String tableName;
    private final List<WriteRequest> requestItems = new ArrayList<WriteRequest>();

    BatchWrite(DynamoDB2Backend backend, String tableName) {
        this.backend = backend;
        this.tableName = tableName;
    }

    private void addRequest(WriteRequest.Builder request) {
        this.requestItems.add((WriteRequest)request.build());
        if (this.requestItems.size() == 25) {
            this.flush();
        }
    }

    void addDelete(AttributeValue key) {
        this.addRequest(WriteRequest.builder().deleteRequest(b -> b.key(Collections.singletonMap("k", key))));
    }

    public void addPut(Map<String, AttributeValue> item) {
        this.addRequest(WriteRequest.builder().putRequest(b -> b.item(item)));
    }

    @Override
    public void close() {
        if (!this.requestItems.isEmpty()) {
            this.flush();
        }
    }

    private void flush() {
        this.backend.client().batchWriteItem(b -> b.requestItems(Collections.singletonMap(this.tableName, this.requestItems)));
        this.requestItems.clear();
    }
}

