/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.inmemory;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.projectnessie.versioned.storage.common.persist.Backend;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.PersistFactory;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.inmemory.InmemoryPersistFactory;

public final class InmemoryBackend
implements Backend {
    final Map<String, Reference> references = new ConcurrentHashMap<String, Reference>();
    final Map<String, Obj> objects = new ConcurrentHashMap<String, Obj>();

    static String compositeKeyRepo(String repoId) {
        return repoId + ":";
    }

    @Nonnull
    public PersistFactory createFactory() {
        return new InmemoryPersistFactory(this);
    }

    public void close() {
        this.references.clear();
        this.objects.clear();
    }

    public Optional<String> setupSchema() {
        return Optional.empty();
    }

    public void eraseRepositories(Set<String> repositoryIds) {
        if (repositoryIds == null || repositoryIds.isEmpty()) {
            return;
        }
        List prefixed = repositoryIds.stream().map(InmemoryBackend::compositeKeyRepo).collect(Collectors.toList());
        Consumer<Map> cleaner = m -> m.keySet().removeIf(k -> prefixed.stream().anyMatch(k::startsWith));
        cleaner.accept(this.references);
        cleaner.accept(this.objects);
    }
}

