/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.inmemory;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.objtypes.UpdateableObj;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.common.persist.ValidatingPersist;
import org.projectnessie.versioned.storage.inmemory.InmemoryBackend;

class InmemoryPersist
implements ValidatingPersist {
    private final InmemoryBackend inmemory;
    private final StoreConfig config;

    InmemoryPersist(InmemoryBackend inmemory, StoreConfig config) {
        this.inmemory = inmemory;
        this.config = config;
    }

    private String compositeKeyRepo() {
        return InmemoryBackend.compositeKeyRepo(this.config.repositoryId());
    }

    private String compositeKey(String id) {
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0);
        return this.config.repositoryId() + ":" + id;
    }

    private String compositeKey(ObjId id) {
        return this.compositeKey(id.toString());
    }

    @Nonnull
    public String name() {
        return "In-Memory";
    }

    @Nonnull
    public StoreConfig config() {
        return this.config;
    }

    public Reference fetchReference(@Nonnull String name) {
        return this.inmemory.references.get(this.compositeKey(name));
    }

    @Nonnull
    public Reference[] fetchReferences(@Nonnull String[] names) {
        Reference[] r = new Reference[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name == null) continue;
            r[i] = this.fetchReference(name);
        }
        return r;
    }

    @Nonnull
    public Reference addReference(@Nonnull Reference reference) throws RefAlreadyExistsException {
        Preconditions.checkArgument((!reference.deleted() ? 1 : 0) != 0, (Object)"Deleted references must not be added");
        Reference ex = this.inmemory.references.putIfAbsent(this.compositeKey(reference.name()), reference);
        if (ex != null) {
            throw new RefAlreadyExistsException(ex);
        }
        return reference;
    }

    @Nonnull
    public Reference markReferenceAsDeleted(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        Reference[] result = new Reference[1];
        Reference asDeleted = reference.withDeleted(true);
        this.inmemory.references.computeIfPresent(this.compositeKey(reference.name()), (k, r) -> {
            result[0] = r;
            return r.pointer().equals(reference.pointer()) && !reference.deleted() ? asDeleted : r;
        });
        Reference r2 = result[0];
        if (r2 == null) {
            throw new RefNotFoundException(reference);
        }
        if (!r2.pointer().equals(reference.pointer()) || r2.deleted()) {
            throw new RefConditionFailedException(r2);
        }
        return asDeleted;
    }

    public void purgeReference(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        Reference[] result = new Reference[1];
        this.inmemory.references.computeIfPresent(this.compositeKey(reference.name()), (k, r) -> {
            result[0] = r;
            return r.pointer().equals(reference.pointer()) && r.deleted() ? null : r;
        });
        Reference r2 = result[0];
        if (r2 == null) {
            throw new RefNotFoundException(reference);
        }
        if (!r2.pointer().equals(reference.pointer()) || !r2.deleted()) {
            throw new RefConditionFailedException(r2);
        }
    }

    @Nonnull
    public Reference updateReferencePointer(@Nonnull Reference reference, @Nonnull ObjId newPointer) throws RefNotFoundException, RefConditionFailedException {
        Reference asUpdated = reference.forNewPointer(newPointer, this.config);
        Reference[] result = new Reference[2];
        Reference c = this.inmemory.references.computeIfPresent(this.compositeKey(reference.name()), (k, r) -> {
            if (!r.deleted() && r.equals((Object)reference)) {
                result[0] = r;
                r = asUpdated;
            } else {
                result[1] = r;
            }
            return r;
        });
        if (c == null) {
            throw new RefNotFoundException(reference);
        }
        Reference r2 = result[0];
        if (r2 != null) {
            return asUpdated;
        }
        throw new RefConditionFailedException(result[1]);
    }

    @Nonnull
    public Obj fetchObj(@Nonnull ObjId id) throws ObjNotFoundException {
        return this.fetchTypedObj(id, null, Obj.class);
    }

    @Nonnull
    public <T extends Obj> T fetchTypedObj(@Nonnull ObjId id, ObjType type, @Nonnull Class<T> typeClass) throws ObjNotFoundException {
        Obj obj = this.inmemory.objects.get(this.compositeKey(id));
        if (obj == null || type != null && !type.equals((Object)obj.type())) {
            throw new ObjNotFoundException(id);
        }
        Obj r = obj;
        return (T)r;
    }

    @Nonnull
    public <T extends Obj> T[] fetchTypedObjsIfExist(@Nonnull ObjId[] ids, ObjType type, @Nonnull Class<T> typeClass) {
        Obj[] r = (Obj[])Array.newInstance(typeClass, ids.length);
        for (int i = 0; i < ids.length; ++i) {
            Obj typed;
            Obj o;
            ObjId id = ids[i];
            if (id == null || (o = this.inmemory.objects.get(this.compositeKey(id))) == null || type != null && !type.equals((Object)o.type())) continue;
            r[i] = typed = o;
        }
        return r;
    }

    public boolean storeObj(@Nonnull Obj obj, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        Preconditions.checkArgument((obj.id() != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
        if (!ignoreSoftSizeRestrictions) {
            this.verifySoftRestrictions(obj);
        }
        long referenced = obj.referenced() != -1L ? this.config.currentTimeMicros() : -1L;
        Obj withReferenced = obj.withReferenced(referenced);
        AtomicBoolean r = new AtomicBoolean(false);
        this.inmemory.objects.compute(this.compositeKey(obj.id()), (key, oldValue) -> {
            if (oldValue == null) {
                return withReferenced;
            }
            r.set(true);
            return withReferenced;
        });
        return !r.get();
    }

    @Nonnull
    public boolean[] storeObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        boolean[] r = new boolean[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            r[i] = this.storeObj(objs[i]);
        }
        return r;
    }

    public void deleteObj(@Nonnull ObjId id) {
        this.inmemory.objects.remove(this.compositeKey(id));
    }

    public void deleteObjs(@Nonnull ObjId[] ids) {
        for (ObjId id : ids) {
            if (id == null) continue;
            this.deleteObj(id);
        }
    }

    public void upsertObj(@Nonnull Obj obj) throws ObjTooLargeException {
        this.verifySoftRestrictions(obj);
        this.inmemory.objects.put(this.compositeKey(obj.id()), obj.withReferenced(this.config.currentTimeMicros()));
    }

    public void upsertObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        for (Obj obj : objs) {
            if (obj == null) continue;
            this.upsertObj(obj);
        }
    }

    public boolean deleteWithReferenced(@Nonnull Obj obj) {
        AtomicBoolean result = new AtomicBoolean();
        this.inmemory.objects.compute(this.compositeKey(obj.id()), (k, v) -> {
            if (v == null) {
                return null;
            }
            if (v.referenced() != obj.referenced()) {
                return v;
            }
            result.set(true);
            return null;
        });
        return result.get();
    }

    public boolean deleteConditional(@Nonnull UpdateableObj obj) {
        return this.updateDeleteConditional(obj, null);
    }

    public boolean updateConditional(@Nonnull UpdateableObj expected, @Nonnull UpdateableObj newValue) {
        ObjId id = expected.id();
        Preconditions.checkArgument((id != null && id.equals(newValue.id()) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)expected.type().equals((Object)newValue.type()));
        Preconditions.checkArgument((!expected.versionToken().equals(newValue.versionToken()) ? 1 : 0) != 0);
        return this.updateDeleteConditional(expected, newValue);
    }

    private boolean updateDeleteConditional(UpdateableObj expected, UpdateableObj newValue) {
        AtomicBoolean result = new AtomicBoolean();
        this.inmemory.objects.compute(this.compositeKey(expected.id()), (k, v) -> {
            if (v == null) {
                return null;
            }
            if (!v.type().equals((Object)expected.type())) {
                return v;
            }
            UpdateableObj uv = (UpdateableObj)v;
            if (!uv.versionToken().equals(expected.versionToken())) {
                return v;
            }
            result.set(true);
            return newValue != null ? newValue.withReferenced(this.config.currentTimeMicros()) : null;
        });
        return result.get();
    }

    public void erase() {
        this.inmemory.eraseRepositories(Collections.singleton(this.config().repositoryId()));
    }

    @Nonnull
    public CloseableIterator<Obj> scanAllObjects(@Nonnull Set<ObjType> returnedObjTypes) {
        return new ScanAllObjectsIterator(returnedObjTypes.isEmpty() ? x -> true : returnedObjTypes::contains);
    }

    private class ScanAllObjectsIterator
    extends AbstractIterator<Obj>
    implements CloseableIterator<Obj> {
        private final Predicate<ObjType> filter;
        final String prefix;
        final Iterator<Map.Entry<String, Obj>> iter;

        ScanAllObjectsIterator(Predicate<ObjType> filter) {
            this.prefix = InmemoryPersist.this.compositeKeyRepo();
            this.iter = InmemoryPersist.this.inmemory.objects.entrySet().iterator();
            this.filter = filter;
        }

        protected Obj computeNext() {
            Obj o;
            Map.Entry<String, Obj> entry;
            String k;
            do {
                if (this.iter.hasNext()) continue;
                return (Obj)this.endOfData();
            } while (!(k = (entry = this.iter.next()).getKey()).startsWith(this.prefix) || !this.filter.test((o = entry.getValue()).type()));
            return o;
        }

        public void close() {
        }
    }
}

