/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.inmemory;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.common.persist.ValidatingPersist;
import org.projectnessie.versioned.storage.inmemory.InmemoryBackend;

class InmemoryPersist
implements ValidatingPersist {
    private final InmemoryBackend inmemory;
    private final StoreConfig config;

    InmemoryPersist(InmemoryBackend inmemory, StoreConfig config) {
        this.inmemory = inmemory;
        this.config = config;
    }

    private String compositeKeyRepo() {
        return InmemoryBackend.compositeKeyRepo(this.config.repositoryId());
    }

    private String compositeKey(String id) {
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0);
        return this.config.repositoryId() + ":" + id;
    }

    private String compositeKey(ObjId id) {
        return this.compositeKey(id.toString());
    }

    @javax.annotation.Nonnull
    @Nonnull
    public String name() {
        return "In-Memory";
    }

    @javax.annotation.Nonnull
    @Nonnull
    public StoreConfig config() {
        return this.config;
    }

    public Reference fetchReference(@javax.annotation.Nonnull @Nonnull String name) {
        return this.inmemory.references.get(this.compositeKey(name));
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Reference[] fetchReferences(@javax.annotation.Nonnull @Nonnull String[] names) {
        Reference[] r = new Reference[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name == null) continue;
            r[i] = this.fetchReference(name);
        }
        return r;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Reference addReference(@javax.annotation.Nonnull @Nonnull Reference reference) throws RefAlreadyExistsException {
        Preconditions.checkArgument((!reference.deleted() ? 1 : 0) != 0, (Object)"Deleted references must not be added");
        Reference ex = this.inmemory.references.putIfAbsent(this.compositeKey(reference.name()), reference);
        if (ex != null) {
            throw new RefAlreadyExistsException(ex);
        }
        return reference;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Reference markReferenceAsDeleted(@javax.annotation.Nonnull @Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        Reference[] result = new Reference[1];
        Reference asDeleted = reference.withDeleted(true);
        this.inmemory.references.computeIfPresent(this.compositeKey(reference.name()), (k, r) -> {
            result[0] = r;
            return r.pointer().equals(reference.pointer()) && !reference.deleted() ? asDeleted : r;
        });
        Reference r2 = result[0];
        if (r2 == null) {
            throw new RefNotFoundException(reference);
        }
        if (!r2.pointer().equals(reference.pointer()) || r2.deleted()) {
            throw new RefConditionFailedException(r2);
        }
        return asDeleted;
    }

    public void purgeReference(@javax.annotation.Nonnull @Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        Reference[] result = new Reference[1];
        this.inmemory.references.computeIfPresent(this.compositeKey(reference.name()), (k, r) -> {
            result[0] = r;
            return r.pointer().equals(reference.pointer()) && r.deleted() ? null : r;
        });
        Reference r2 = result[0];
        if (r2 == null) {
            throw new RefNotFoundException(reference);
        }
        if (!r2.pointer().equals(reference.pointer()) || !r2.deleted()) {
            throw new RefConditionFailedException(r2);
        }
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Reference updateReferencePointer(@javax.annotation.Nonnull @Nonnull Reference reference, @javax.annotation.Nonnull @Nonnull ObjId newPointer) throws RefNotFoundException, RefConditionFailedException {
        Reference asUpdated = reference.forNewPointer(newPointer, this.config);
        Reference[] result = new Reference[2];
        Reference c = this.inmemory.references.computeIfPresent(this.compositeKey(reference.name()), (k, r) -> {
            if (!r.deleted() && r.equals(reference)) {
                result[0] = r;
                r = asUpdated;
            } else {
                result[1] = r;
            }
            return r;
        });
        if (c == null) {
            throw new RefNotFoundException(reference);
        }
        Reference r2 = result[0];
        if (r2 != null) {
            return asUpdated;
        }
        throw new RefConditionFailedException(result[1]);
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Obj fetchObj(@javax.annotation.Nonnull @Nonnull ObjId id) throws ObjNotFoundException {
        Obj obj = this.inmemory.objects.get(this.compositeKey(id));
        if (obj == null) {
            throw new ObjNotFoundException(id);
        }
        return obj;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public <T extends Obj> T fetchTypedObj(@javax.annotation.Nonnull @Nonnull ObjId id, ObjType type, Class<T> typeClass) throws ObjNotFoundException {
        Obj obj = this.inmemory.objects.get(this.compositeKey(id));
        if (obj == null || obj.type() != type) {
            throw new ObjNotFoundException(id);
        }
        Obj r = obj;
        return (T)r;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public ObjType fetchObjType(@javax.annotation.Nonnull @Nonnull ObjId id) throws ObjNotFoundException {
        Obj obj = this.inmemory.objects.get(this.compositeKey(id));
        if (obj == null) {
            throw new ObjNotFoundException(id);
        }
        return obj.type();
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Obj[] fetchObjs(@javax.annotation.Nonnull @Nonnull ObjId[] ids) throws ObjNotFoundException {
        Obj[] r = new Obj[ids.length];
        ArrayList notFound = null;
        for (int i = 0; i < ids.length; ++i) {
            ObjId id = ids[i];
            if (id == null) continue;
            try {
                r[i] = this.fetchObj(id);
                continue;
            }
            catch (ObjNotFoundException e) {
                if (notFound == null) {
                    notFound = new ArrayList();
                }
                notFound.addAll(e.objIds());
            }
        }
        if (notFound != null) {
            throw new ObjNotFoundException(notFound);
        }
        return r;
    }

    public boolean storeObj(@javax.annotation.Nonnull @Nonnull Obj obj, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        Obj ex;
        Preconditions.checkArgument((obj.id() != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
        if (!ignoreSoftSizeRestrictions) {
            this.verifySoftRestrictions(obj);
        }
        return (ex = this.inmemory.objects.putIfAbsent(this.compositeKey(obj.id()), obj)) == null;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public boolean[] storeObjs(@javax.annotation.Nonnull @Nonnull Obj[] objs) throws ObjTooLargeException {
        boolean[] r = new boolean[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            r[i] = this.storeObj(objs[i]);
        }
        return r;
    }

    public void deleteObj(@javax.annotation.Nonnull @Nonnull ObjId id) {
        this.inmemory.objects.remove(this.compositeKey(id));
    }

    public void deleteObjs(@javax.annotation.Nonnull @Nonnull ObjId[] ids) {
        for (ObjId id : ids) {
            this.deleteObj(id);
        }
    }

    public void upsertObj(@javax.annotation.Nonnull @Nonnull Obj obj) throws ObjTooLargeException {
        this.verifySoftRestrictions(obj);
        this.inmemory.objects.put(this.compositeKey(obj.id()), obj);
    }

    public void upsertObjs(@javax.annotation.Nonnull @Nonnull Obj[] objs) throws ObjTooLargeException {
        for (Obj obj : objs) {
            this.upsertObj(obj);
        }
    }

    public void erase() {
        this.inmemory.eraseRepositories(Collections.singleton(this.config().repositoryId()));
    }

    @javax.annotation.Nonnull
    @Nonnull
    public CloseableIterator<Obj> scanAllObjects(@javax.annotation.Nonnull @Nonnull Set<ObjType> returnedObjTypes) {
        return new ScanAllObjectsIterator(returnedObjTypes::contains);
    }

    private class ScanAllObjectsIterator
    extends AbstractIterator<Obj>
    implements CloseableIterator<Obj> {
        private final Predicate<ObjType> filter;
        final String prefix;
        Iterator<Map.Entry<String, Obj>> iter;

        ScanAllObjectsIterator(Predicate<ObjType> filter) {
            this.prefix = InmemoryPersist.this.compositeKeyRepo();
            this.iter = InmemoryPersist.this.inmemory.objects.entrySet().iterator();
            this.filter = filter;
        }

        protected Obj computeNext() {
            Obj o;
            Map.Entry<String, Obj> entry;
            String k;
            do {
                if (this.iter.hasNext()) continue;
                return (Obj)this.endOfData();
            } while (!(k = (entry = this.iter.next()).getKey()).startsWith(this.prefix) || !this.filter.test((o = entry.getValue()).type()));
            return o;
        }

        public void close() {
        }
    }
}

