/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb.serializers;

import java.util.List;
import org.bson.Document;
import org.bson.types.Binary;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.TagObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.mongodb.MongoDBSerde;
import org.projectnessie.versioned.storage.mongodb.serializers.ObjSerializer;

public class TagObjSerializer
implements ObjSerializer<TagObj> {
    public static final TagObjSerializer INSTANCE = new TagObjSerializer();
    private static final String COL_TAG = "t";
    private static final String COL_TAG_MESSAGE = "m";
    private static final String COL_TAG_HEADERS = "h";
    private static final String COL_TAG_SIGNATURE = "s";

    private TagObjSerializer() {
    }

    @Override
    public String fieldName() {
        return COL_TAG;
    }

    @Override
    public void objToDoc(TagObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) {
        ByteString signature;
        String message = obj.message();
        if (message != null) {
            doc.put(COL_TAG_MESSAGE, (Object)message);
        }
        Document headerDoc = new Document();
        CommitHeaders headers = obj.headers();
        if (headers != null) {
            for (String s : headers.keySet()) {
                headerDoc.put(s, (Object)headers.getAll(s));
            }
            if (!headerDoc.isEmpty()) {
                doc.put(COL_TAG_HEADERS, (Object)headerDoc);
            }
        }
        if ((signature = obj.signature()) != null) {
            doc.put(COL_TAG_SIGNATURE, (Object)MongoDBSerde.bytesToBinary(signature));
        }
    }

    @Override
    public TagObj docToObj(ObjId id, ObjType type, long referenced, Document doc, String versionToken) {
        CommitHeaders tagHeaders = null;
        Document headerDoc = (Document)doc.get((Object)COL_TAG_HEADERS, Document.class);
        if (headerDoc != null) {
            CommitHeaders.Builder headers = CommitHeaders.newCommitHeaders();
            headerDoc.forEach((k, o) -> {
                List l = (List)o;
                l.forEach(hv -> headers.add(k, hv));
            });
            tagHeaders = headers.build();
        }
        return TagObj.tag((ObjId)id, (long)referenced, (String)doc.getString((Object)COL_TAG_MESSAGE), (CommitHeaders)tagHeaders, (ByteString)MongoDBSerde.binaryToBytes((Binary)doc.get((Object)COL_TAG_SIGNATURE, Binary.class)));
    }
}

