/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb.serializers;

import org.bson.Document;
import org.bson.types.Binary;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.projectnessie.versioned.storage.common.objtypes.StringObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.mongodb.MongoDBSerde;
import org.projectnessie.versioned.storage.mongodb.serializers.ObjSerializer;

public class StringObjSerializer
implements ObjSerializer<StringObj> {
    public static final StringObjSerializer INSTANCE = new StringObjSerializer();
    private static final String COL_STRING = "s";
    private static final String COL_STRING_CONTENT_TYPE = "y";
    private static final String COL_STRING_COMPRESSION = "c";
    private static final String COL_STRING_FILENAME = "f";
    private static final String COL_STRING_PREDECESSORS = "p";
    private static final String COL_STRING_TEXT = "t";

    private StringObjSerializer() {
    }

    @Override
    public String fieldName() {
        return COL_STRING;
    }

    @Override
    public void objToDoc(StringObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) {
        String s = obj.contentType();
        if (s != null && !s.isEmpty()) {
            doc.put(COL_STRING_CONTENT_TYPE, (Object)s);
        }
        doc.put(COL_STRING_COMPRESSION, (Object)obj.compression().name());
        s = obj.filename();
        if (s != null && !s.isEmpty()) {
            doc.put(COL_STRING_FILENAME, (Object)s);
        }
        MongoDBSerde.objIdsToDoc(doc, COL_STRING_PREDECESSORS, obj.predecessors());
        doc.put(COL_STRING_TEXT, (Object)MongoDBSerde.bytesToBinary(obj.text()));
    }

    @Override
    public StringObj docToObj(ObjId id, ObjType type, long referenced, Document doc, String versionToken) {
        return StringObj.stringData((ObjId)id, (long)referenced, (String)doc.getString((Object)COL_STRING_CONTENT_TYPE), (Compression)Compression.valueOf((String)doc.getString((Object)COL_STRING_COMPRESSION)), (String)doc.getString((Object)COL_STRING_FILENAME), MongoDBSerde.binaryToObjIds(doc.getList((Object)COL_STRING_PREDECESSORS, Binary.class)), (ByteString)MongoDBSerde.binaryToBytes((Binary)doc.get((Object)COL_STRING_TEXT, Binary.class)));
    }
}

