/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.mongodb.MongoClientProducer;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MongoClientProducer", generator="Immutables")
@Immutable
public final class ImmutableMongoClientProducer
extends MongoClientProducer {
    private final String connectionString;

    private ImmutableMongoClientProducer(String connectionString) {
        this.connectionString = connectionString;
    }

    @Override
    String connectionString() {
        return this.connectionString;
    }

    public final ImmutableMongoClientProducer withConnectionString(String value) {
        String newValue = Objects.requireNonNull(value, "connectionString");
        if (this.connectionString.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoClientProducer(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoClientProducer && this.equalTo(0, (ImmutableMongoClientProducer)another);
    }

    private boolean equalTo(int synthetic, ImmutableMongoClientProducer another) {
        return this.connectionString.equals(another.connectionString);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.connectionString.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MongoClientProducer").omitNullValues().add("connectionString", (Object)this.connectionString).toString();
    }

    public static ImmutableMongoClientProducer copyOf(MongoClientProducer instance) {
        if (instance instanceof ImmutableMongoClientProducer) {
            return (ImmutableMongoClientProducer)instance;
        }
        return ImmutableMongoClientProducer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MongoClientProducer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONNECTION_STRING = 1L;
        private long initBits = 1L;
        @Nullable
        private String connectionString;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MongoClientProducer instance) {
            Objects.requireNonNull(instance, "instance");
            this.connectionString(instance.connectionString());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionString(String connectionString) {
            this.connectionString = Objects.requireNonNull(connectionString, "connectionString");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMongoClientProducer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMongoClientProducer(this.connectionString);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("connectionString");
            }
            return "Cannot build MongoClientProducer, some of required attributes are not set " + attributes;
        }
    }
}

