/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.bson.Document;
import org.projectnessie.versioned.storage.common.persist.Backend;
import org.projectnessie.versioned.storage.mongodb.MongoDBBackendConfig;
import org.projectnessie.versioned.storage.mongodb.MongoDBPersistFactory;

class MongoDBBackend
implements Backend {
    private final MongoDBBackendConfig config;
    private final MongoClient client;
    private final boolean closeClient;
    private MongoCollection<Document> refs;
    private MongoCollection<Document> objs;

    MongoDBBackend(@javax.annotation.Nonnull @Nonnull MongoDBBackendConfig config, boolean closeClient) {
        this.config = config;
        this.client = config.client();
        this.closeClient = closeClient;
    }

    @javax.annotation.Nonnull
    @Nonnull
    MongoCollection<Document> refs() {
        return this.refs;
    }

    @javax.annotation.Nonnull
    @Nonnull
    MongoCollection<Document> objs() {
        return this.objs;
    }

    private synchronized void initialize() {
        if (this.refs == null) {
            String databaseName = this.config.databaseName();
            MongoDatabase database = this.client.getDatabase(Objects.requireNonNull(databaseName, "Database name must be set"));
            this.refs = database.getCollection("refs");
            this.objs = database.getCollection("objs");
        }
    }

    @javax.annotation.Nonnull
    @Nonnull
    public MongoDBPersistFactory createFactory() {
        this.initialize();
        return new MongoDBPersistFactory(this);
    }

    public synchronized void close() {
        if (this.closeClient) {
            this.client.close();
        }
    }

    public void setupSchema() {
        this.initialize();
    }

    public String configInfo() {
        return "database name: " + this.config.databaseName();
    }
}

