/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoWriteException;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteInsert;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.agrona.collections.Object2IntHashMap;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.projectnessie.versioned.storage.common.objtypes.ContentValueObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexSegmentsObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.objtypes.RefObj;
import org.projectnessie.versioned.storage.common.objtypes.StringObj;
import org.projectnessie.versioned.storage.common.objtypes.TagObj;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.mongodb.MongoDBBackend;

public class MongoDBPersist
implements Persist {
    private static final Map<ObjType, StoreObjDesc<?>> STORE_OBJ_TYPE = new EnumMap(ObjType.class);
    private static final ObjType[] ALL_OBJ_TYPES = ObjType.values();
    private final StoreConfig config;
    private final MongoDBBackend backend;

    MongoDBPersist(MongoDBBackend backend, StoreConfig config) {
        this.config = config;
        this.backend = backend;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public String name() {
        return "MongoDB";
    }

    @javax.annotation.Nonnull
    @Nonnull
    public StoreConfig config() {
        return this.config;
    }

    private Document idRefDoc(Reference reference) {
        return this.idRefDoc(reference.name());
    }

    private Document idRefDoc(String name) {
        Document idDoc = new Document();
        idDoc.put("r", (Object)this.config.repositoryId());
        idDoc.put("n", (Object)name);
        return idDoc;
    }

    private Document idObjDoc(ObjId id) {
        Document idDoc = new Document();
        idDoc.put("r", (Object)this.config.repositoryId());
        idDoc.put("i", (Object)MongoDBPersist.objIdToBinary(id));
        return idDoc;
    }

    private static Binary bytesToBinary(ByteString bytes) {
        return new Binary(bytes.toByteArray());
    }

    private static ByteString binaryToBytes(Binary binary) {
        return binary != null ? UnsafeByteOperations.unsafeWrap((byte[])binary.getData()) : null;
    }

    private static Binary objIdToBinary(ObjId id) {
        return new Binary(id.asByteArray());
    }

    private static ObjId binaryToObjId(Binary id) {
        return ObjId.objIdFromByteArray((byte[])id.getData());
    }

    private static void objIdsToDoc(Document doc, String n, List<ObjId> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        doc.put(n, MongoDBPersist.objIdsToBinary(ids));
    }

    private static List<Binary> objIdsToBinary(List<ObjId> ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        return ids.stream().map(MongoDBPersist::objIdToBinary).collect(Collectors.toList());
    }

    private static List<ObjId> binaryToObjIds(List<Binary> ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        return ids.stream().map(MongoDBPersist::binaryToObjId).collect(Collectors.toList());
    }

    private static void binaryToObjIds(List<Binary> ids, Consumer<ObjId> receiver) {
        if (ids != null) {
            ids.stream().map(MongoDBPersist::binaryToObjId).forEach(receiver);
        }
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Reference addReference(@javax.annotation.Nonnull @Nonnull Reference reference) throws RefAlreadyExistsException {
        Preconditions.checkArgument((!reference.deleted() ? 1 : 0) != 0, (Object)"Deleted references must not be added");
        Document doc = new Document();
        doc.put("_id", (Object)this.idRefDoc(reference));
        doc.put("p", (Object)MongoDBPersist.objIdToBinary(reference.pointer()));
        doc.put("d", (Object)reference.deleted());
        try {
            this.backend.refs().insertOne((Object)doc);
        }
        catch (MongoWriteException e) {
            if (e.getError().getCategory() == ErrorCategory.DUPLICATE_KEY) {
                throw new RefAlreadyExistsException(this.fetchReference(reference.name()));
            }
            throw e;
        }
        return reference;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Reference markReferenceAsDeleted(@javax.annotation.Nonnull @Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        UpdateResult result = this.backend.refs().updateOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)this.idRefDoc(reference)), Filters.eq((String)"p", (Object)MongoDBPersist.objIdToBinary(reference.pointer())), Filters.eq((String)"d", (Object)false)}), Updates.set((String)"d", (Object)true));
        if (result.getModifiedCount() != 1L) {
            Reference ex = this.fetchReference(reference.name());
            if (ex == null) {
                throw new RefNotFoundException(reference.name());
            }
            throw new RefConditionFailedException(ex);
        }
        return Reference.reference((String)reference.name(), (ObjId)reference.pointer(), (boolean)true);
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Reference updateReferencePointer(@javax.annotation.Nonnull @Nonnull Reference reference, @javax.annotation.Nonnull @Nonnull ObjId newPointer) throws RefNotFoundException, RefConditionFailedException {
        Reference updated = Reference.reference((String)reference.name(), (ObjId)newPointer, (boolean)false);
        UpdateResult result = this.backend.refs().updateOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)this.idRefDoc(reference)), Filters.eq((String)"p", (Object)MongoDBPersist.objIdToBinary(reference.pointer())), Filters.eq((String)"d", (Object)false)}), Updates.set((String)"p", (Object)MongoDBPersist.objIdToBinary(newPointer)));
        if (result.getModifiedCount() != 1L) {
            if (result.getMatchedCount() == 1L) {
                return updated;
            }
            Reference ex = this.fetchReference(reference.name());
            if (ex == null) {
                throw new RefNotFoundException(reference.name());
            }
            throw new RefConditionFailedException(ex);
        }
        return updated;
    }

    public void purgeReference(@javax.annotation.Nonnull @Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        DeleteResult result = this.backend.refs().deleteOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)this.idRefDoc(reference)), Filters.eq((String)"p", (Object)MongoDBPersist.objIdToBinary(reference.pointer())), Filters.eq((String)"d", (Object)true)}));
        if (result.getDeletedCount() != 1L) {
            Reference ex = this.fetchReference(reference.name());
            if (ex == null) {
                throw new RefNotFoundException(reference.name());
            }
            throw new RefConditionFailedException(ex);
        }
    }

    public Reference fetchReference(@javax.annotation.Nonnull @Nonnull String name) {
        FindIterable result = this.backend.refs().find(Filters.eq((String)"_id", (Object)this.idRefDoc(name)));
        Document doc = (Document)result.first();
        if (doc == null) {
            return null;
        }
        return Reference.reference((String)name, (ObjId)MongoDBPersist.binaryToObjId((Binary)doc.get((Object)"p", Binary.class)), (boolean)doc.getBoolean((Object)"d"));
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Reference[] fetchReferences(@javax.annotation.Nonnull @Nonnull String[] names) {
        List nameIdDocs = Arrays.stream(names).filter(Objects::nonNull).map(this::idRefDoc).collect(Collectors.toList());
        FindIterable result = this.backend.refs().find(Filters.in((String)"_id", nameIdDocs));
        Reference[] r = new Reference[names.length];
        for (Document doc : result) {
            String name = ((Document)doc.get((Object)"_id", Document.class)).getString((Object)"n");
            Reference reference = Reference.reference((String)name, (ObjId)MongoDBPersist.binaryToObjId((Binary)doc.get((Object)"p", Binary.class)), (boolean)doc.getBoolean((Object)"d"));
            for (int i = 0; i < names.length; ++i) {
                if (!name.equals(names[i])) continue;
                r[i] = reference;
            }
        }
        return r;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Obj fetchObj(@javax.annotation.Nonnull @Nonnull ObjId id) throws ObjNotFoundException {
        FindIterable result = this.backend.objs().find(Filters.eq((String)"_id", (Object)this.idObjDoc(id)));
        Document doc = (Document)result.first();
        if (doc == null) {
            throw new ObjNotFoundException(id);
        }
        return this.docToObj(id, doc);
    }

    @javax.annotation.Nonnull
    @Nonnull
    public <T extends Obj> T fetchTypedObj(@javax.annotation.Nonnull @Nonnull ObjId id, ObjType type, Class<T> typeClass) throws ObjNotFoundException {
        Obj obj;
        FindIterable result = this.backend.objs().find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)this.idObjDoc(id)), Filters.eq((String)"y", (Object)type.shortName())}));
        Document doc = (Document)result.first();
        if (doc == null) {
            throw new ObjNotFoundException(id);
        }
        Obj r = obj = this.docToObj(id, doc);
        return (T)r;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public ObjType fetchObjType(@javax.annotation.Nonnull @Nonnull ObjId id) throws ObjNotFoundException {
        FindIterable result = this.backend.objs().find(Filters.eq((String)"_id", (Object)this.idObjDoc(id)));
        Document doc = (Document)result.first();
        if (doc == null) {
            throw new ObjNotFoundException(id);
        }
        return this.objTypeFromItem(doc);
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Obj[] fetchObjs(@javax.annotation.Nonnull @Nonnull ObjId[] ids) throws ObjNotFoundException {
        ArrayList<Document> list = new ArrayList<Document>(ids.length);
        Object2IntHashMap idToIndex = new Object2IntHashMap(ids.length * 2, 0.65f, -1);
        Obj[] r = new Obj[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            ObjId id = ids[i];
            if (id == null) continue;
            list.add(this.idObjDoc(id));
            idToIndex.put((Object)id, i);
        }
        if (!list.isEmpty()) {
            this.fetchObjsPage(r, list, (Object2IntHashMap<ObjId>)idToIndex);
        }
        ArrayList<ObjId> notFound = null;
        for (int i = 0; i < ids.length; ++i) {
            ObjId id = ids[i];
            if (r[i] != null || id == null) continue;
            if (notFound == null) {
                notFound = new ArrayList<ObjId>();
            }
            notFound.add(id);
        }
        if (notFound != null) {
            throw new ObjNotFoundException(notFound);
        }
        return r;
    }

    private void fetchObjsPage(Obj[] r, List<Document> list, Object2IntHashMap<ObjId> idToIndex) {
        FindIterable result = this.backend.objs().find(Filters.in((String)"_id", list));
        for (Document doc : result) {
            Obj obj = this.docToObj(doc);
            int idx = idToIndex.getValue((Object)obj.id());
            if (idx == -1) continue;
            r[idx] = obj;
        }
    }

    public boolean storeObj(@javax.annotation.Nonnull @Nonnull Obj obj, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        Document doc = this.objToDoc(obj, ignoreSoftSizeRestrictions);
        try {
            this.backend.objs().insertOne((Object)doc);
        }
        catch (MongoWriteException e) {
            if (e.getError().getCategory() == ErrorCategory.DUPLICATE_KEY) {
                return false;
            }
            throw e;
        }
        return true;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public boolean[] storeObjs(@javax.annotation.Nonnull @Nonnull Obj[] objs) throws ObjTooLargeException {
        ArrayList<InsertOneModel> docs = new ArrayList<InsertOneModel>(objs.length);
        for (Obj obj : objs) {
            if (obj == null) continue;
            docs.add(new InsertOneModel((Object)this.objToDoc(obj, false)));
        }
        boolean[] r = new boolean[objs.length];
        ArrayList inserts = new ArrayList(docs);
        while (!inserts.isEmpty()) {
            try {
                BulkWriteResult res = this.backend.objs().bulkWrite(inserts);
                for (BulkWriteInsert insert : res.getInserts()) {
                    ObjId id2 = MongoDBPersist.objIdFromBulkWriteInsert(insert);
                    r[MongoDBPersist.objIdIndex((Obj[])objs, (ObjId)id2)] = id2 != null;
                }
                break;
            }
            catch (MongoBulkWriteException e) {
                BulkWriteInsert insert;
                List errs = e.getWriteErrors();
                insert = errs.iterator();
                while (insert.hasNext()) {
                    BulkWriteError err = (BulkWriteError)insert.next();
                    if (err.getCategory() == ErrorCategory.DUPLICATE_KEY) continue;
                    throw e;
                }
                BulkWriteResult res = e.getWriteResult();
                inserts.clear();
                res.getInserts().stream().map(MongoDBPersist::objIdFromBulkWriteInsert).mapToInt(id -> MongoDBPersist.objIdIndex(objs, id)).mapToObj(docs::get).forEach(inserts::add);
            }
        }
        return r;
    }

    private static ObjId objIdFromDoc(Document doc) {
        return MongoDBPersist.binaryToObjId((Binary)((Document)doc.get((Object)"_id", Document.class)).get((Object)"i", Binary.class));
    }

    private ObjType objTypeFromItem(Document doc) {
        return this.objTypeFromItem(doc.getString((Object)"y"));
    }

    private ObjType objTypeFromItem(String shortType) {
        for (ObjType type : ALL_OBJ_TYPES) {
            if (!type.shortName().equals(shortType)) continue;
            return type;
        }
        throw new IllegalStateException("Cannot deserialize object short type " + shortType);
    }

    private StoreObjDesc<?> objTypeFromDoc(Document doc) {
        ObjType type = this.objTypeFromItem(doc);
        StoreObjDesc<?> storeObj = STORE_OBJ_TYPE.get(type);
        Preconditions.checkState((storeObj != null ? 1 : 0) != 0, (String)"Cannot deserialize object type %s", (Object)type);
        return storeObj;
    }

    private static int objIdIndex(Obj[] objs, ObjId id) {
        for (int i = 0; i < objs.length; ++i) {
            if (!id.equals(objs[i].id())) continue;
            return i;
        }
        throw new IllegalArgumentException("ObjId " + id + " not in objs");
    }

    private static ObjId objIdFromBulkWriteInsert(BulkWriteInsert insert) {
        return ObjId.objIdFromByteArray((byte[])insert.getId().asDocument().getBinary((Object)"i").getData());
    }

    public void deleteObj(@javax.annotation.Nonnull @Nonnull ObjId id) {
        this.backend.objs().deleteOne(Filters.eq((String)"_id", (Object)this.idObjDoc(id)));
    }

    public void deleteObjs(@javax.annotation.Nonnull @Nonnull ObjId[] ids) {
        List list = Stream.of(ids).filter(Objects::nonNull).map(this::idObjDoc).collect(Collectors.toList());
        if (list.isEmpty()) {
            return;
        }
        this.backend.objs().deleteMany(Filters.in((String)"_id", list));
    }

    public void updateObj(@javax.annotation.Nonnull @Nonnull Obj obj) throws ObjTooLargeException, ObjNotFoundException {
        ObjId id = obj.id();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
        Document doc = this.objToDoc(obj, true);
        Document result = (Document)this.backend.objs().findOneAndReplace(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)this.idObjDoc(id)), Filters.eq((String)"y", (Object)obj.type().shortName())}), (Object)doc);
        if (result == null) {
            throw new ObjNotFoundException(id);
        }
    }

    public void updateObjs(@javax.annotation.Nonnull @Nonnull Obj[] objs) throws ObjTooLargeException, ObjNotFoundException {
        for (Obj obj : objs) {
            this.updateObj(obj);
        }
    }

    @javax.annotation.Nonnull
    @Nonnull
    public CloseableIterator<Obj> scanAllObjects(@javax.annotation.Nonnull @Nonnull Set<ObjType> returnedObjTypes) {
        return new ScanAllObjectsIterator(returnedObjTypes);
    }

    public void erase() {
        Bson repoIdFilter = Filters.eq((String)"_id.r", (Object)this.config.repositoryId());
        Stream.of(this.backend.refs(), this.backend.objs()).forEach(coll -> coll.deleteMany(repoIdFilter));
    }

    private Obj docToObj(Document doc) {
        ObjId id = MongoDBPersist.objIdFromDoc(doc);
        return this.docToObj(id, doc);
    }

    private Obj docToObj(@javax.annotation.Nonnull @Nonnull ObjId id, Document doc) {
        StoreObjDesc<?> storeObj = this.objTypeFromDoc(doc);
        Document inner = (Document)doc.get((Object)storeObj.typeName, Document.class);
        return storeObj.docToObj(id, inner);
    }

    private Document objToDoc(@javax.annotation.Nonnull @Nonnull Obj obj, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        ObjId id = obj.id();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
        ObjType type = obj.type();
        StoreObjDesc<?> storeObj = STORE_OBJ_TYPE.get(type);
        Preconditions.checkArgument((storeObj != null ? 1 : 0) != 0, (String)"Cannot serialize object type %s ", (Object)type);
        Document doc = new Document();
        Document inner = new Document();
        doc.put("_id", (Object)this.idObjDoc(id));
        doc.put("y", (Object)type.shortName());
        int incrementalIndexSizeLimit = ignoreSoftSizeRestrictions ? Integer.MAX_VALUE : this.effectiveIncrementalIndexSizeLimit();
        int indexSizeLimit = ignoreSoftSizeRestrictions ? Integer.MAX_VALUE : this.effectiveIndexSegmentSizeLimit();
        storeObj.objToDoc(obj, inner, incrementalIndexSizeLimit, indexSizeLimit);
        doc.put(storeObj.typeName, (Object)inner);
        return doc;
    }

    private static void fromStripesDocList(Document doc, String attrName, Consumer<IndexStripe> consumer) {
        List refIndexStripes = doc.getList((Object)attrName, Document.class);
        if (refIndexStripes != null) {
            for (Document seg : refIndexStripes) {
                consumer.accept(IndexStripe.indexStripe((StoreKey)StoreKey.keyFromString((String)seg.getString((Object)"f")), (StoreKey)StoreKey.keyFromString((String)seg.getString((Object)"l")), (ObjId)MongoDBPersist.binaryToObjId((Binary)seg.get((Object)"s", Binary.class))));
            }
        }
    }

    @javax.annotation.Nonnull
    @Nonnull
    private static List<Document> stripesToDocs(List<IndexStripe> stripes) {
        ArrayList<Document> stripesDocs = new ArrayList<Document>();
        for (IndexStripe stripe : stripes) {
            Document sv = new Document();
            sv.put("f", (Object)stripe.firstKey().rawString());
            sv.put("l", (Object)stripe.lastKey().rawString());
            sv.put("s", (Object)MongoDBPersist.objIdToBinary(stripe.segment()));
            stripesDocs.add(sv);
        }
        return stripesDocs;
    }

    static {
        STORE_OBJ_TYPE.put(ObjType.COMMIT, new StoreObjDesc<CommitObj>("c"){

            @Override
            void objToDoc(CommitObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) throws ObjTooLargeException {
                doc.put("q", (Object)obj.seq());
                doc.put("c", (Object)obj.created());
                ObjId referenceIndex = obj.referenceIndex();
                if (referenceIndex != null) {
                    doc.put("x", (Object)MongoDBPersist.objIdToBinary(referenceIndex));
                }
                doc.put("m", (Object)obj.message());
                MongoDBPersist.objIdsToDoc(doc, "t", obj.tail());
                MongoDBPersist.objIdsToDoc(doc, "s", obj.secondaryParents());
                ByteString index = obj.incrementalIndex();
                if (index.size() > incrementalIndexLimit) {
                    throw new ObjTooLargeException(index.size(), incrementalIndexLimit);
                }
                doc.put("i", (Object)MongoDBPersist.bytesToBinary(index));
                List indexStripes = obj.referenceIndexStripes();
                if (!indexStripes.isEmpty()) {
                    doc.put("r", (Object)MongoDBPersist.stripesToDocs(indexStripes));
                }
                Document headerDoc = new Document();
                CommitHeaders headers = obj.headers();
                for (String s : headers.keySet()) {
                    headerDoc.put(s, (Object)headers.getAll(s));
                }
                if (!headerDoc.isEmpty()) {
                    doc.put("h", (Object)headerDoc);
                }
                doc.put("n", (Object)obj.incompleteIndex());
                doc.put("y", (Object)obj.commitType().shortName());
            }

            @Override
            CommitObj docToObj(ObjId id, Document doc) {
                CommitObj.Builder b = CommitObj.commitBuilder().id(id).seq(doc.getLong((Object)"q").longValue()).created(doc.getLong((Object)"c").longValue()).message(doc.getString((Object)"m")).incrementalIndex(MongoDBPersist.binaryToBytes((Binary)doc.get((Object)"i", Binary.class))).incompleteIndex(doc.getBoolean((Object)"n").booleanValue()).commitType(CommitType.fromShortName((String)doc.getString((Object)"y")));
                Binary v = (Binary)doc.get((Object)"x", Binary.class);
                if (v != null) {
                    b.referenceIndex(MongoDBPersist.binaryToObjId(v));
                }
                MongoDBPersist.fromStripesDocList(doc, "r", arg_0 -> ((CommitObj.Builder)b).addReferenceIndexStripes(arg_0));
                MongoDBPersist.binaryToObjIds(doc.getList((Object)"t", Binary.class), arg_0 -> ((CommitObj.Builder)b).addTail(arg_0));
                MongoDBPersist.binaryToObjIds(doc.getList((Object)"s", Binary.class), arg_0 -> ((CommitObj.Builder)b).addSecondaryParents(arg_0));
                CommitHeaders.Builder headers = CommitHeaders.newCommitHeaders();
                Document headerDoc = (Document)doc.get((Object)"h", Document.class);
                if (headerDoc != null) {
                    headerDoc.forEach((k, o) -> {
                        List l = (List)o;
                        l.forEach(hv -> headers.add(k, hv));
                    });
                }
                b.headers(headers.build());
                return b.build();
            }
        });
        STORE_OBJ_TYPE.put(ObjType.REF, new StoreObjDesc<RefObj>("e"){

            @Override
            void objToDoc(RefObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) {
                doc.put("n", (Object)obj.name());
                doc.put("c", (Object)obj.createdAtMicros());
                doc.put("p", (Object)MongoDBPersist.objIdToBinary(obj.initialPointer()));
            }

            @Override
            RefObj docToObj(ObjId id, Document doc) {
                return RefObj.ref((ObjId)id, (String)doc.getString((Object)"n"), (ObjId)MongoDBPersist.binaryToObjId((Binary)doc.get((Object)"p", Binary.class)), (long)doc.getLong((Object)"c"));
            }
        });
        STORE_OBJ_TYPE.put(ObjType.VALUE, new StoreObjDesc<ContentValueObj>("v"){

            @Override
            void objToDoc(ContentValueObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) {
                doc.put("i", (Object)obj.contentId());
                doc.put("p", (Object)obj.payload());
                doc.put("d", (Object)MongoDBPersist.bytesToBinary(obj.data()));
            }

            @Override
            ContentValueObj docToObj(ObjId id, Document doc) {
                return ContentValueObj.contentValue((ObjId)id, (String)doc.getString((Object)"i"), (int)doc.getInteger((Object)"p"), (ByteString)MongoDBPersist.binaryToBytes((Binary)doc.get((Object)"d", Binary.class)));
            }
        });
        STORE_OBJ_TYPE.put(ObjType.INDEX_SEGMENTS, new StoreObjDesc<IndexSegmentsObj>("I"){

            @Override
            void objToDoc(IndexSegmentsObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) {
                doc.put("s", (Object)MongoDBPersist.stripesToDocs(obj.stripes()));
            }

            @Override
            IndexSegmentsObj docToObj(ObjId id, Document doc) {
                ArrayList stripes = new ArrayList();
                MongoDBPersist.fromStripesDocList(doc, "s", stripes::add);
                return IndexSegmentsObj.indexSegments((ObjId)id, stripes);
            }
        });
        STORE_OBJ_TYPE.put(ObjType.INDEX, new StoreObjDesc<IndexObj>("i"){

            @Override
            void objToDoc(IndexObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) throws ObjTooLargeException {
                ByteString index = obj.index();
                if (index.size() > maxSerializedIndexSize) {
                    throw new ObjTooLargeException(index.size(), maxSerializedIndexSize);
                }
                doc.put("i", (Object)MongoDBPersist.bytesToBinary(index));
            }

            @Override
            IndexObj docToObj(ObjId id, Document doc) {
                return IndexObj.index((ObjId)id, (ByteString)MongoDBPersist.binaryToBytes((Binary)doc.get((Object)"i", Binary.class)));
            }
        });
        STORE_OBJ_TYPE.put(ObjType.TAG, new StoreObjDesc<TagObj>("t"){

            @Override
            void objToDoc(TagObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) {
                ByteString signature;
                doc.put("i", (Object)MongoDBPersist.objIdToBinary(obj.commitId()));
                String message = obj.message();
                if (message != null) {
                    doc.put("m", (Object)message);
                }
                Document headerDoc = new Document();
                CommitHeaders headers = obj.headers();
                if (headers != null) {
                    for (String s : headers.keySet()) {
                        headerDoc.put(s, (Object)headers.getAll(s));
                    }
                    if (!headerDoc.isEmpty()) {
                        doc.put("h", (Object)headerDoc);
                    }
                }
                if ((signature = obj.signature()) != null) {
                    doc.put("s", (Object)MongoDBPersist.bytesToBinary(signature));
                }
            }

            @Override
            TagObj docToObj(ObjId id, Document doc) {
                CommitHeaders tagHeaders = null;
                Document headerDoc = (Document)doc.get((Object)"h", Document.class);
                if (headerDoc != null) {
                    CommitHeaders.Builder headers = CommitHeaders.newCommitHeaders();
                    headerDoc.forEach((k, o) -> {
                        List l = (List)o;
                        l.forEach(hv -> headers.add(k, hv));
                    });
                    tagHeaders = headers.build();
                }
                return TagObj.tag((ObjId)id, (ObjId)MongoDBPersist.binaryToObjId((Binary)doc.get((Object)"i", Binary.class)), (String)doc.getString((Object)"m"), (CommitHeaders)tagHeaders, (ByteString)MongoDBPersist.binaryToBytes((Binary)doc.get((Object)"s", Binary.class)));
            }
        });
        STORE_OBJ_TYPE.put(ObjType.STRING, new StoreObjDesc<StringObj>("s"){

            @Override
            void objToDoc(StringObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) {
                String s = obj.contentType();
                if (s != null && !s.isEmpty()) {
                    doc.put("y", (Object)s);
                }
                doc.put("c", (Object)obj.compression().name());
                s = obj.filename();
                if (s != null && !s.isEmpty()) {
                    doc.put("f", (Object)s);
                }
                MongoDBPersist.objIdsToDoc(doc, "p", obj.predecessors());
                doc.put("t", (Object)MongoDBPersist.bytesToBinary(obj.text()));
            }

            @Override
            StringObj docToObj(ObjId id, Document doc) {
                return StringObj.stringData((ObjId)id, (String)doc.getString((Object)"y"), (Compression)Compression.valueOf((String)doc.getString((Object)"c")), (String)doc.getString((Object)"f"), (List)MongoDBPersist.binaryToObjIds(doc.getList((Object)"p", Binary.class)), (ByteString)MongoDBPersist.binaryToBytes((Binary)doc.get((Object)"t", Binary.class)));
            }
        });
    }

    private class ScanAllObjectsIterator
    extends AbstractIterator<Obj>
    implements CloseableIterator<Obj> {
        private final MongoCursor<Document> result;

        public ScanAllObjectsIterator(Set<ObjType> returnedObjTypes) {
            List objTypeShortNames = returnedObjTypes.stream().map(ObjType::shortName).collect(Collectors.toList());
            this.result = MongoDBPersist.this.backend.objs().find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id.r", (Object)MongoDBPersist.this.config.repositoryId()), Filters.in((String)"y", objTypeShortNames)})).iterator();
        }

        protected Obj computeNext() {
            if (!this.result.hasNext()) {
                return (Obj)this.endOfData();
            }
            Document doc = (Document)this.result.next();
            return MongoDBPersist.this.docToObj(doc);
        }

        public void close() {
            this.result.close();
        }
    }

    static abstract class StoreObjDesc<O extends Obj> {
        final String typeName;

        StoreObjDesc(String typeName) {
            this.typeName = typeName;
        }

        abstract void objToDoc(O var1, Document var2, int var3, int var4) throws ObjTooLargeException;

        abstract O docToObj(ObjId var1, Document var2);
    }
}

