/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.projectnessie.versioned.storage.mongodb.ImmutableMongoDBBackendConfig;
import org.projectnessie.versioned.storage.mongodb.MongoClientProducer;
import org.projectnessie.versioned.storage.mongodb.MongoDBBackend;
import org.projectnessie.versioned.storage.mongodb.MongoDBBackendConfig;
import org.projectnessie.versioned.storage.testextension.BackendTestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;

public class MongoDBBackendTestFactory
implements BackendTestFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDBBackendTestFactory.class);
    public static final String MONGO_DB_NAME = "test";
    public static final int MONGO_PORT = 27017;
    private MongoDBContainer container;
    private String connectionString;

    public String getName() {
        return "MongoDB";
    }

    public void startMongo(Optional<String> containerNetworkId) {
        if (this.container != null) {
            throw new IllegalStateException("Already started");
        }
        String version = System.getProperty("it.nessie.container.mongodb.tag", "latest");
        int retry = 0;
        while (true) {
            MongoDBContainer c = (MongoDBContainer)new MongoDBContainer("mongo:" + version).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
            containerNetworkId.ifPresent(arg_0 -> ((MongoDBContainer)c).withNetworkMode(arg_0));
            try {
                c.start();
                this.container = c;
            }
            catch (ContainerLaunchException e) {
                c.close();
                if (e.getCause() == null || retry >= 3) {
                    LOGGER.error("Launch of container {} failed", (Object)c.getDockerImageName(), (Object)e);
                    throw new RuntimeException(e);
                }
                LOGGER.warn("Launch of container {} failed, will retry...", (Object)c.getDockerImageName(), (Object)e);
                ++retry;
                continue;
            }
            break;
        }
        this.connectionString = this.container.getReplicaSetUrl(MONGO_DB_NAME);
        if (containerNetworkId.isPresent()) {
            String hostPort = this.container.getHost() + ":" + this.container.getMappedPort(27017);
            String networkHostPort = this.container.getCurrentContainerInfo().getConfig().getHostName() + ":27017";
            this.connectionString = this.connectionString.replace(hostPort, networkHostPort);
        }
    }

    public MongoDBBackend createNewBackend() {
        MongoClient client = this.buildNewClient();
        ImmutableMongoDBBackendConfig config = MongoDBBackendConfig.builder().databaseName(MONGO_DB_NAME).client(client).build();
        return new MongoDBBackend(config, true);
    }

    @VisibleForTesting
    MongoClient buildNewClient() {
        return MongoClientProducer.builder().connectionString(this.connectionString).build().createClient();
    }

    public void start() {
        this.startMongo(Optional.empty());
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        finally {
            this.container = null;
        }
    }

    public Map<String, String> getQuarkusConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("quarkus.mongodb.connection-string", this.connectionString);
        config.put("quarkus.mongodb.database", MONGO_DB_NAME);
        return config;
    }
}

