/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb.serializers;

import org.bson.Document;
import org.bson.types.Binary;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.ContentValueObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.mongodb.MongoDBSerde;
import org.projectnessie.versioned.storage.mongodb.serializers.ObjSerializer;

public class ContentValueObjSerializer
implements ObjSerializer<ContentValueObj> {
    public static final ContentValueObjSerializer INSTANCE = new ContentValueObjSerializer();
    private static final String COL_VALUE = "v";
    private static final String COL_VALUE_CONTENT_ID = "i";
    private static final String COL_VALUE_PAYLOAD = "p";
    private static final String COL_VALUE_DATA = "d";

    private ContentValueObjSerializer() {
    }

    @Override
    public String fieldName() {
        return COL_VALUE;
    }

    @Override
    public void objToDoc(ContentValueObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) {
        doc.put(COL_VALUE_CONTENT_ID, (Object)obj.contentId());
        doc.put(COL_VALUE_PAYLOAD, (Object)obj.payload());
        doc.put(COL_VALUE_DATA, (Object)MongoDBSerde.bytesToBinary(obj.data()));
    }

    @Override
    public ContentValueObj docToObj(ObjId id, Document doc) {
        return ContentValueObj.contentValue((ObjId)id, (String)doc.getString((Object)COL_VALUE_CONTENT_ID), (int)doc.getInteger((Object)COL_VALUE_PAYLOAD), (ByteString)MongoDBSerde.binaryToBytes((Binary)doc.get((Object)COL_VALUE_DATA, Binary.class)));
    }
}

