/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb.serializers;

import org.bson.Document;
import org.bson.types.Binary;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.objtypes.IndexObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.mongodb.MongoDBSerde;
import org.projectnessie.versioned.storage.mongodb.serializers.ObjSerializer;

public class IndexObjSerializer
implements ObjSerializer<IndexObj> {
    public static final IndexObjSerializer INSTANCE = new IndexObjSerializer();
    private static final String COL_INDEX = "i";
    private static final String COL_INDEX_INDEX = "i";

    private IndexObjSerializer() {
    }

    @Override
    public String fieldName() {
        return "i";
    }

    @Override
    public void objToDoc(IndexObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) throws ObjTooLargeException {
        ByteString index = obj.index();
        if (index.size() > maxSerializedIndexSize) {
            throw new ObjTooLargeException(index.size(), maxSerializedIndexSize);
        }
        doc.put("i", (Object)MongoDBSerde.bytesToBinary(index));
    }

    @Override
    public IndexObj docToObj(ObjId id, Document doc) {
        return IndexObj.index((ObjId)id, (ByteString)MongoDBSerde.binaryToBytes((Binary)doc.get((Object)"i", Binary.class)));
    }
}

