/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb.serializers;

import java.util.ArrayList;
import org.bson.Document;
import org.projectnessie.versioned.storage.common.objtypes.IndexSegmentsObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.mongodb.MongoDBSerde;
import org.projectnessie.versioned.storage.mongodb.serializers.ObjSerializer;

public class IndexSegmentsObjSerializer
implements ObjSerializer<IndexSegmentsObj> {
    public static final IndexSegmentsObjSerializer INSTANCE = new IndexSegmentsObjSerializer();
    private static final String COL_SEGMENTS = "I";
    private static final String COL_SEGMENTS_STRIPES = "s";

    private IndexSegmentsObjSerializer() {
    }

    @Override
    public String fieldName() {
        return COL_SEGMENTS;
    }

    @Override
    public void objToDoc(IndexSegmentsObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) {
        doc.put(COL_SEGMENTS_STRIPES, MongoDBSerde.stripesToDocs(obj.stripes()));
    }

    @Override
    public IndexSegmentsObj docToObj(ObjId id, Document doc) {
        ArrayList stripes = new ArrayList();
        MongoDBSerde.fromStripesDocList(doc, COL_SEGMENTS_STRIPES, stripes::add);
        return IndexSegmentsObj.indexSegments((ObjId)id, stripes);
    }
}

