/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb.serializers;

import org.bson.Document;
import org.bson.types.Binary;
import org.projectnessie.versioned.storage.common.objtypes.RefObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.mongodb.MongoDBSerde;
import org.projectnessie.versioned.storage.mongodb.serializers.ObjSerializer;

public class RefObjSerializer
implements ObjSerializer<RefObj> {
    public static final RefObjSerializer INSTANCE = new RefObjSerializer();
    private static final String COL_REF = "e";
    private static final String COL_REF_NAME = "n";
    private static final String COL_REF_INITIAL_POINTER = "p";
    private static final String COL_REF_CREATED_AT = "c";
    private static final String COL_REF_EXTENDED_INFO = "e";

    private RefObjSerializer() {
    }

    @Override
    public String fieldName() {
        return "e";
    }

    @Override
    public void objToDoc(RefObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) {
        doc.put(COL_REF_NAME, (Object)obj.name());
        doc.put(COL_REF_CREATED_AT, (Object)obj.createdAtMicros());
        doc.put(COL_REF_INITIAL_POINTER, (Object)MongoDBSerde.objIdToBinary(obj.initialPointer()));
        ObjId extendedInfoObj = obj.extendedInfoObj();
        if (extendedInfoObj != null) {
            doc.put("e", (Object)MongoDBSerde.objIdToBinary(extendedInfoObj));
        }
    }

    @Override
    public RefObj docToObj(ObjId id, Document doc) {
        return RefObj.ref((ObjId)id, (String)doc.getString((Object)COL_REF_NAME), (ObjId)MongoDBSerde.binaryToObjId((Binary)doc.get((Object)COL_REF_INITIAL_POINTER, Binary.class)), (long)doc.getLong((Object)COL_REF_CREATED_AT), (ObjId)MongoDBSerde.binaryToObjId((Binary)doc.get((Object)"e", Binary.class)));
    }
}

