/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.projectnessie.versioned.storage.common.persist.Backend;
import org.projectnessie.versioned.storage.mongodb.MongoDBBackendConfig;
import org.projectnessie.versioned.storage.mongodb.MongoDBPersistFactory;

class MongoDBBackend
implements Backend {
    private final MongoDBBackendConfig config;
    private final MongoClient client;
    private final boolean closeClient;
    private MongoCollection<Document> refs;
    private MongoCollection<Document> objs;

    MongoDBBackend(@Nonnull MongoDBBackendConfig config, boolean closeClient) {
        this.config = config;
        this.client = config.client();
        this.closeClient = closeClient;
    }

    @Nonnull
    MongoCollection<Document> refs() {
        return this.refs;
    }

    @Nonnull
    MongoCollection<Document> objs() {
        return this.objs;
    }

    private synchronized void initialize() {
        if (this.refs == null) {
            String databaseName = this.config.databaseName();
            MongoDatabase database = this.client.getDatabase(Objects.requireNonNull(databaseName, "Database name must be set"));
            this.refs = database.getCollection("refs");
            this.objs = database.getCollection("objs");
        }
    }

    @Nonnull
    public MongoDBPersistFactory createFactory() {
        this.initialize();
        return new MongoDBPersistFactory(this);
    }

    public synchronized void close() {
        if (this.closeClient) {
            this.client.close();
        }
    }

    public void setupSchema() {
        this.initialize();
    }

    public String configInfo() {
        return "database name: " + this.config.databaseName();
    }

    public void eraseRepositories(Set<String> repositoryIds) {
        if (repositoryIds == null || repositoryIds.isEmpty()) {
            return;
        }
        Bson repoIdFilter = Filters.in((String)"_id.r", repositoryIds);
        Stream.of(this.refs(), this.objs()).forEach(coll -> coll.deleteMany(repoIdFilter));
    }
}

