/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb.serializers;

import org.bson.Document;
import org.bson.types.Binary;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.UniqueIdObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.mongodb.MongoDBSerde;
import org.projectnessie.versioned.storage.mongodb.serializers.ObjSerializer;

public class UniqueIdObjSerializer
implements ObjSerializer<UniqueIdObj> {
    public static final UniqueIdObjSerializer INSTANCE = new UniqueIdObjSerializer();
    private static final String COL_UNIQUE = "u";
    static final String COL_UNIQUE_SPACE = "s";
    static final String COL_UNIQUE_VALUE = "v";

    private UniqueIdObjSerializer() {
    }

    @Override
    public String fieldName() {
        return COL_UNIQUE;
    }

    @Override
    public void objToDoc(UniqueIdObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) {
        doc.put(COL_UNIQUE_SPACE, (Object)obj.space());
        doc.put(COL_UNIQUE_VALUE, (Object)MongoDBSerde.bytesToBinary(obj.value()));
    }

    @Override
    public UniqueIdObj docToObj(ObjId id, ObjType type, Document doc) {
        return UniqueIdObj.uniqueId((ObjId)id, (String)doc.getString((Object)COL_UNIQUE_SPACE), (ByteString)MongoDBSerde.binaryToBytes((Binary)doc.get((Object)COL_UNIQUE_VALUE, Binary.class)));
    }
}

