/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb.serializers;

import java.util.List;
import org.bson.Document;
import org.bson.types.Binary;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.mongodb.MongoDBSerde;
import org.projectnessie.versioned.storage.mongodb.serializers.ObjSerializer;

public class CommitObjSerializer
implements ObjSerializer<CommitObj> {
    public static final CommitObjSerializer INSTANCE = new CommitObjSerializer();
    private static final String COL_COMMIT = "c";
    private static final String COL_COMMIT_CREATED = "c";
    private static final String COL_COMMIT_SEQ = "q";
    private static final String COL_COMMIT_MESSAGE = "m";
    private static final String COL_COMMIT_HEADERS = "h";
    private static final String COL_COMMIT_REFERENCE_INDEX = "x";
    private static final String COL_COMMIT_REFERENCE_INDEX_STRIPES = "r";
    private static final String COL_COMMIT_TAIL = "t";
    private static final String COL_COMMIT_SECONDARY_PARENTS = "s";
    private static final String COL_COMMIT_INCREMENTAL_INDEX = "i";
    private static final String COL_COMMIT_INCOMPLETE_INDEX = "n";
    private static final String COL_COMMIT_TYPE = "y";

    private CommitObjSerializer() {
    }

    @Override
    public String fieldName() {
        return "c";
    }

    @Override
    public void objToDoc(CommitObj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) throws ObjTooLargeException {
        doc.put(COL_COMMIT_SEQ, (Object)obj.seq());
        doc.put("c", (Object)obj.created());
        ObjId referenceIndex = obj.referenceIndex();
        if (referenceIndex != null) {
            doc.put(COL_COMMIT_REFERENCE_INDEX, (Object)MongoDBSerde.objIdToBinary(referenceIndex));
        }
        doc.put(COL_COMMIT_MESSAGE, (Object)obj.message());
        MongoDBSerde.objIdsToDoc(doc, COL_COMMIT_TAIL, obj.tail());
        MongoDBSerde.objIdsToDoc(doc, COL_COMMIT_SECONDARY_PARENTS, obj.secondaryParents());
        ByteString index = obj.incrementalIndex();
        if (index.size() > incrementalIndexLimit) {
            throw new ObjTooLargeException(index.size(), incrementalIndexLimit);
        }
        doc.put(COL_COMMIT_INCREMENTAL_INDEX, (Object)MongoDBSerde.bytesToBinary(index));
        List indexStripes = obj.referenceIndexStripes();
        if (!indexStripes.isEmpty()) {
            doc.put(COL_COMMIT_REFERENCE_INDEX_STRIPES, MongoDBSerde.stripesToDocs(indexStripes));
        }
        Document headerDoc = new Document();
        CommitHeaders headers = obj.headers();
        for (String s : headers.keySet()) {
            headerDoc.put(s, (Object)headers.getAll(s));
        }
        if (!headerDoc.isEmpty()) {
            doc.put(COL_COMMIT_HEADERS, (Object)headerDoc);
        }
        doc.put(COL_COMMIT_INCOMPLETE_INDEX, (Object)obj.incompleteIndex());
        doc.put(COL_COMMIT_TYPE, (Object)obj.commitType().shortName());
    }

    @Override
    public CommitObj docToObj(ObjId id, ObjType type, Document doc, String versionToken) {
        CommitObj.Builder b = CommitObj.commitBuilder().id(id).seq(doc.getLong((Object)COL_COMMIT_SEQ).longValue()).created(doc.getLong((Object)"c").longValue()).message(doc.getString((Object)COL_COMMIT_MESSAGE)).incrementalIndex(MongoDBSerde.binaryToBytes((Binary)doc.get((Object)COL_COMMIT_INCREMENTAL_INDEX, Binary.class))).incompleteIndex(doc.getBoolean((Object)COL_COMMIT_INCOMPLETE_INDEX).booleanValue()).commitType(CommitType.fromShortName((String)doc.getString((Object)COL_COMMIT_TYPE)));
        Binary v = (Binary)doc.get((Object)COL_COMMIT_REFERENCE_INDEX, Binary.class);
        if (v != null) {
            b.referenceIndex(MongoDBSerde.binaryToObjId(v));
        }
        MongoDBSerde.fromStripesDocList(doc, COL_COMMIT_REFERENCE_INDEX_STRIPES, arg_0 -> ((CommitObj.Builder)b).addReferenceIndexStripes(arg_0));
        MongoDBSerde.binaryToObjIds(doc.getList((Object)COL_COMMIT_TAIL, Binary.class), arg_0 -> ((CommitObj.Builder)b).addTail(arg_0));
        MongoDBSerde.binaryToObjIds(doc.getList((Object)COL_COMMIT_SECONDARY_PARENTS, Binary.class), arg_0 -> ((CommitObj.Builder)b).addSecondaryParents(arg_0));
        CommitHeaders.Builder headers = CommitHeaders.newCommitHeaders();
        Document headerDoc = (Document)doc.get((Object)COL_COMMIT_HEADERS, Document.class);
        if (headerDoc != null) {
            headerDoc.forEach((k, o) -> {
                List l = (List)o;
                l.forEach(hv -> headers.add(k, hv));
            });
        }
        b.headers(headers.build());
        return b.build();
    }
}

