/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mongodb.client.MongoClient;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.mongodb.MongoDBBackendBaseConfig;
import org.projectnessie.versioned.storage.mongodb.MongoDBBackendConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MongoDBBackendConfig", generator="Immutables")
@Immutable
public final class ImmutableMongoDBBackendConfig
implements MongoDBBackendConfig {
    private final String databaseName;
    private final MongoClient client;

    private ImmutableMongoDBBackendConfig(String databaseName, MongoClient client) {
        this.databaseName = databaseName;
        this.client = client;
    }

    @Override
    public String databaseName() {
        return this.databaseName;
    }

    @Override
    public MongoClient client() {
        return this.client;
    }

    public final ImmutableMongoDBBackendConfig withDatabaseName(String value) {
        String newValue = Objects.requireNonNull(value, "databaseName");
        if (this.databaseName.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoDBBackendConfig(newValue, this.client);
    }

    public final ImmutableMongoDBBackendConfig withClient(MongoClient value) {
        if (this.client == value) {
            return this;
        }
        MongoClient newValue = Objects.requireNonNull(value, "client");
        return new ImmutableMongoDBBackendConfig(this.databaseName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoDBBackendConfig && this.equalTo(0, (ImmutableMongoDBBackendConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableMongoDBBackendConfig another) {
        return this.databaseName.equals(another.databaseName) && this.client.equals((Object)another.client);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.databaseName.hashCode();
        h += (h << 5) + this.client.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MongoDBBackendConfig").omitNullValues().add("databaseName", (Object)this.databaseName).add("client", (Object)this.client).toString();
    }

    public static ImmutableMongoDBBackendConfig copyOf(MongoDBBackendConfig instance) {
        if (instance instanceof ImmutableMongoDBBackendConfig) {
            return (ImmutableMongoDBBackendConfig)instance;
        }
        return ImmutableMongoDBBackendConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MongoDBBackendConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATABASE_NAME = 1L;
        private static final long INIT_BIT_CLIENT = 2L;
        private long initBits = 3L;
        @Nullable
        private String databaseName;
        @Nullable
        private MongoClient client;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MongoDBBackendConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(MongoDBBackendBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            MongoDBBackendBaseConfig instance;
            long bits = 0L;
            if (object instanceof MongoDBBackendConfig) {
                instance = (MongoDBBackendConfig)object;
                if ((bits & 1L) == 0L) {
                    this.databaseName(instance.databaseName());
                    bits |= 1L;
                }
                this.client(instance.client());
            }
            if (object instanceof MongoDBBackendBaseConfig) {
                instance = (MongoDBBackendBaseConfig)object;
                if ((bits & 1L) == 0L) {
                    this.databaseName(instance.databaseName());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder databaseName(String databaseName) {
            this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(MongoClient client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMongoDBBackendConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMongoDBBackendConfig(this.databaseName, this.client);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("databaseName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("client");
            }
            return "Cannot build MongoDBBackendConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

