/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb2;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mongodb.client.MongoClient;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.mongodb2.MongoDB2BackendBaseConfig;
import org.projectnessie.versioned.storage.mongodb2.MongoDB2BackendConfig;

@Generated(from="MongoDB2BackendConfig", generator="Immutables")
public final class ImmutableMongoDB2BackendConfig
implements MongoDB2BackendConfig {
    private final String databaseName;
    private final MongoClient client;

    private ImmutableMongoDB2BackendConfig(String databaseName, MongoClient client) {
        this.databaseName = databaseName;
        this.client = client;
    }

    @Override
    public String databaseName() {
        return this.databaseName;
    }

    @Override
    public MongoClient client() {
        return this.client;
    }

    public final ImmutableMongoDB2BackendConfig withDatabaseName(String value) {
        String newValue = Objects.requireNonNull(value, "databaseName");
        if (this.databaseName.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoDB2BackendConfig(newValue, this.client);
    }

    public final ImmutableMongoDB2BackendConfig withClient(MongoClient value) {
        if (this.client == value) {
            return this;
        }
        MongoClient newValue = Objects.requireNonNull(value, "client");
        return new ImmutableMongoDB2BackendConfig(this.databaseName, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoDB2BackendConfig && this.equalsByValue((ImmutableMongoDB2BackendConfig)another);
    }

    private boolean equalsByValue(ImmutableMongoDB2BackendConfig another) {
        return this.databaseName.equals(another.databaseName) && this.client.equals((Object)another.client);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.databaseName.hashCode();
        h += (h << 5) + this.client.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MongoDB2BackendConfig").omitNullValues().add("databaseName", (Object)this.databaseName).add("client", (Object)this.client).toString();
    }

    public static ImmutableMongoDB2BackendConfig copyOf(MongoDB2BackendConfig instance) {
        if (instance instanceof ImmutableMongoDB2BackendConfig) {
            return (ImmutableMongoDB2BackendConfig)instance;
        }
        return ImmutableMongoDB2BackendConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MongoDB2BackendConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DATABASE_NAME = 1L;
        private static final long INIT_BIT_CLIENT = 2L;
        private long initBits = 3L;
        private String databaseName;
        private MongoClient client;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MongoDB2BackendBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(MongoDB2BackendConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            MongoDB2BackendBaseConfig instance;
            long bits = 0L;
            if (object instanceof MongoDB2BackendBaseConfig) {
                instance = (MongoDB2BackendBaseConfig)object;
                if ((bits & 1L) == 0L) {
                    this.databaseName(instance.databaseName());
                    bits |= 1L;
                }
            }
            if (object instanceof MongoDB2BackendConfig) {
                instance = (MongoDB2BackendConfig)object;
                if ((bits & 1L) == 0L) {
                    this.databaseName(instance.databaseName());
                    bits |= 1L;
                }
                this.client(instance.client());
            }
        }

        @CanIgnoreReturnValue
        public final Builder databaseName(String databaseName) {
            this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(MongoClient client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMongoDB2BackendConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMongoDB2BackendConfig(this.databaseName, this.client);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("databaseName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("client");
            }
            return "Cannot build MongoDB2BackendConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

