/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb2;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.types.Binary;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.UnsafeByteOperations;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.persist.ObjId;

public final class MongoDB2Serde {
    private static final String COL_STRIPES_FIRST_KEY = "f";
    private static final String COL_STRIPES_LAST_KEY = "l";
    private static final String COL_STRIPES_SEGMENT = "s";

    private MongoDB2Serde() {
    }

    public static Binary bytesToBinary(ByteString bytes) {
        return new Binary(bytes.toByteArray());
    }

    public static ByteString binaryToBytes(Binary binary) {
        return binary != null ? UnsafeByteOperations.unsafeWrap((byte[])binary.getData()) : null;
    }

    public static Binary objIdToBinary(ObjId id) {
        return new Binary(id.asByteArray());
    }

    public static ObjId binaryToObjId(Binary id) {
        return id != null ? ObjId.objIdFromByteArray((byte[])id.getData()) : null;
    }

    public static void objIdsToDoc(Document doc, String n, List<ObjId> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        doc.put(n, MongoDB2Serde.objIdsToBinary(ids));
    }

    public static List<Binary> objIdsToBinary(List<ObjId> ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        return ids.stream().map(MongoDB2Serde::objIdToBinary).collect(Collectors.toList());
    }

    public static List<ObjId> binaryToObjIds(List<Binary> ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        return ids.stream().map(MongoDB2Serde::binaryToObjId).collect(Collectors.toList());
    }

    public static void binaryToObjIds(List<Binary> ids, Consumer<ObjId> receiver) {
        if (ids != null) {
            ids.stream().map(MongoDB2Serde::binaryToObjId).forEach(receiver);
        }
    }

    public static void fromStripesDocList(Document doc, String attrName, Consumer<IndexStripe> consumer) {
        List refIndexStripes = doc.getList((Object)attrName, Document.class);
        if (refIndexStripes != null) {
            for (Document seg : refIndexStripes) {
                consumer.accept(IndexStripe.indexStripe((StoreKey)StoreKey.keyFromString((String)seg.getString((Object)COL_STRIPES_FIRST_KEY)), (StoreKey)StoreKey.keyFromString((String)seg.getString((Object)COL_STRIPES_LAST_KEY)), (ObjId)MongoDB2Serde.binaryToObjId((Binary)seg.get((Object)COL_STRIPES_SEGMENT, Binary.class))));
            }
        }
    }

    @Nonnull
    public static List<Document> stripesToDocs(List<IndexStripe> stripes) {
        ArrayList<Document> stripesDocs = new ArrayList<Document>();
        for (IndexStripe stripe : stripes) {
            Document sv = new Document();
            sv.put(COL_STRIPES_FIRST_KEY, (Object)stripe.firstKey().rawString());
            sv.put(COL_STRIPES_LAST_KEY, (Object)stripe.lastKey().rawString());
            sv.put(COL_STRIPES_SEGMENT, (Object)MongoDB2Serde.objIdToBinary(stripe.segment()));
            stripesDocs.add(sv);
        }
        return stripesDocs;
    }
}

