/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

final class Batcher<T>
implements AutoCloseable {
    private final Set<T> buffer;
    private final int capacity;
    private final Consumer<List<T>> flush;

    Batcher(int capacity, Consumer<List<T>> flush) {
        this.capacity = capacity;
        this.flush = flush;
        this.buffer = Sets.newLinkedHashSetWithExpectedSize((int)capacity);
    }

    void add(T entity) {
        this.buffer.add(entity);
        if (this.buffer.size() == this.capacity) {
            this.flush();
        }
    }

    private void flush() {
        if (!this.buffer.isEmpty()) {
            ArrayList<T> list = new ArrayList<T>(this.buffer);
            this.buffer.clear();
            this.flush.accept(list);
        }
    }

    @Override
    public void close() {
        this.flush();
    }
}

