/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.agrona.collections.ObjectHashSet;
import org.projectnessie.api.NessieVersion;
import org.projectnessie.nessie.relocated.protobuf.UnsafeByteOperations;
import org.projectnessie.versioned.storage.common.logic.RepositoryDescription;
import org.projectnessie.versioned.storage.common.objtypes.CustomObjType;
import org.projectnessie.versioned.storage.common.objtypes.StandardObjType;
import org.projectnessie.versioned.storage.common.objtypes.UniqueIdObj;
import org.projectnessie.versioned.storage.common.objtypes.UpdateableObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.serialize.SmileSerialization;
import org.projectnessie.versioned.transfer.Batcher;
import org.projectnessie.versioned.transfer.ExportContext;
import org.projectnessie.versioned.transfer.NessieExporter;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;
import org.projectnessie.versioned.transfer.related.CompositeTransferRelatedObjects;
import org.projectnessie.versioned.transfer.related.TransferRelatedObjects;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

abstract class ExportCommon {
    final ExportFileSupplier exportFiles;
    final NessieExporter exporter;
    final TransferRelatedObjects transferRelatedObjects;
    final TransferTypes.ExportVersion exportVersion;
    private Batcher<Obj> genericObjBatcher;

    ExportCommon(ExportFileSupplier exportFiles, NessieExporter exporter, TransferTypes.ExportVersion exportVersion) {
        this.exportFiles = exportFiles;
        this.exporter = exporter;
        this.exportVersion = ExportCommon.verifyExportVersion(exportVersion);
        ObjectHashSet seen = new ObjectHashSet();
        this.transferRelatedObjects = CompositeTransferRelatedObjects.createCompositeTransferRelatedObjects(exporter.genericObjectResolvers(), arg_0 -> ((ObjectHashSet)seen).add(arg_0));
    }

    private static TransferTypes.ExportVersion verifyExportVersion(TransferTypes.ExportVersion exportVersion) {
        if (exportVersion == null) {
            exportVersion = TransferTypes.ExportVersion.UNRECOGNIZED;
        }
        switch (exportVersion) {
            case V1: {
                throw new IllegalArgumentException("Cannot export using export-version " + exportVersion.getNumber());
            }
            case V2: 
            case V3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unimplemented export-version " + exportVersion.getNumber());
            }
        }
        return exportVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransferTypes.ExportMeta exportRepo() throws IOException {
        ExportContext exportContext = this.createExportContext(this.getExportVersion());
        try {
            try (Batcher genericObjBatcher = new Batcher(this.exporter.commitBatchSize(), objs -> this.mapGenericObjs((List<Obj>)objs, exportContext));){
                this.genericObjBatcher = genericObjBatcher;
                this.exporter.progressListener().progress(ProgressEvent.STARTED);
                this.prepare(exportContext);
                this.exporter.progressListener().progress(ProgressEvent.START_COMMITS);
                TransferTypes.HeadsAndForks headsAndForks = this.exportCommits(exportContext);
                exportContext.commitOutput.finishCurrentFile();
                this.writeHeadsAndForks(headsAndForks);
                this.exporter.progressListener().progress(ProgressEvent.END_COMMITS);
                this.exporter.progressListener().progress(ProgressEvent.START_NAMED_REFERENCES);
                this.exportReferences(exportContext);
                exportContext.namedReferenceOutput.finishCurrentFile();
                this.exporter.progressListener().progress(ProgressEvent.END_NAMED_REFERENCES);
                this.exporter.progressListener().progress(ProgressEvent.START_META);
                this.writeRepositoryInformation();
            }
            finally {
                this.genericObjBatcher = null;
            }
            TransferTypes.ExportMeta meta = exportContext.finish();
            this.writeExportMeta(meta);
            this.exporter.progressListener().progress(ProgressEvent.END_META, meta);
            this.exporter.progressListener().progress(ProgressEvent.FINISHED);
            TransferTypes.ExportMeta exportMeta = meta;
            return exportMeta;
        }
        finally {
            exportContext.closeSilently();
        }
    }

    final long currentTimestampMillis() {
        return this.exporter.clock().millis();
    }

    ExportContext createExportContext(TransferTypes.ExportVersion exportVersion) {
        return new ExportContext(this.exportFiles, this.exporter, TransferTypes.ExportMeta.newBuilder().setNessieVersion(NessieVersion.NESSIE_VERSION).setCreatedMillisEpoch(this.currentTimestampMillis()).setVersion(exportVersion));
    }

    TransferTypes.ExportVersion getExportVersion() {
        return this.exportVersion;
    }

    abstract void prepare(ExportContext var1);

    abstract void exportReferences(ExportContext var1);

    abstract TransferTypes.HeadsAndForks exportCommits(ExportContext var1);

    void writeRepositoryInformation() throws IOException {
        this.handleGenericObjs(this.transferRelatedObjects.repositoryRelatedObjects());
        RepositoryDescription repositoryDescription = this.exporter.repositoryLogic().fetchRepositoryDescription();
        if (repositoryDescription != null) {
            this.writeRepositoryDescription(TransferTypes.RepositoryDescriptionProto.newBuilder().putAllProperties(repositoryDescription.properties()).setRepositoryId(this.exporter.persist().config().repositoryId()).setRepositoryCreatedTimestampMillis(repositoryDescription.repositoryCreatedTime().toEpochMilli()).setOldestCommitTimestampMillis(repositoryDescription.oldestPossibleCommitTime().toEpochMilli()).setDefaultBranchName(repositoryDescription.defaultBranchName()).build());
        }
    }

    void writeExportMeta(TransferTypes.ExportMeta meta) throws IOException {
        try (OutputStream output = this.exportFiles.newFileOutput("export-metadata");){
            meta.writeTo(output);
        }
    }

    void writeHeadsAndForks(TransferTypes.HeadsAndForks hf) throws IOException {
        try (OutputStream output = this.exportFiles.newFileOutput("heads-and-forks");){
            hf.writeTo(output);
        }
    }

    void writeRepositoryDescription(TransferTypes.RepositoryDescriptionProto repositoryDescription) throws IOException {
        try (OutputStream output = this.exportFiles.newFileOutput("repository-description");){
            repositoryDescription.writeTo(output);
        }
    }

    void handleGenericObjs(Set<ObjId> ids) {
        if (ids.isEmpty()) {
            return;
        }
        ObjId[] idArray = (ObjId[])ids.toArray(ObjId[]::new);
        Obj[] objs = this.exporter.persist().fetchObjsIfExist(idArray);
        Arrays.stream(objs).filter(Objects::nonNull).forEach(this.genericObjBatcher::add);
    }

    private void mapGenericObjs(List<Obj> objs, ExportContext exportContext) {
        for (Obj o : objs) {
            TransferTypes.RelatedObj custom = this.mapGenericObj(o);
            exportContext.writeGeneric(custom);
            this.exporter.progressListener().progress(ProgressEvent.GENERIC_WRITTEN);
        }
    }

    private TransferTypes.RelatedObj mapGenericObj(Obj obj) {
        TransferTypes.RelatedObj.Builder genericObj = TransferTypes.RelatedObj.newBuilder().setId(obj.id().asBytes());
        ObjType objType = obj.type();
        if (objType.equals((Object)StandardObjType.UNIQUE)) {
            UniqueIdObj uniqueIdObj = (UniqueIdObj)obj;
            genericObj.setTypeName(StandardObjType.UNIQUE.shortName()).setSpace(uniqueIdObj.space()).setData(uniqueIdObj.value());
        } else if (objType instanceof CustomObjType) {
            UpdateableObj updateableObj;
            String versionToken;
            byte[] serialized = SmileSerialization.serializeObj((Obj)obj, compression -> genericObj.setCompression(compression.valueString()));
            genericObj.setTypeName(objType.shortName()).setEncoding(TransferTypes.Encoding.Smile).setData(UnsafeByteOperations.unsafeWrap((byte[])serialized));
            if (obj instanceof UpdateableObj && (versionToken = (updateableObj = (UpdateableObj)obj).versionToken()) != null) {
                genericObj.setVersionToken(versionToken);
            }
        } else {
            throw new IllegalArgumentException("Unhandled object type " + objType.name());
        }
        return genericObj.build();
    }
}

