/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.CommitMetaSerializer;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.paging.PaginationIterator;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.StandardObjType;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.versionstore.RefMapping;
import org.projectnessie.versioned.storage.versionstore.TypeMapping;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.transfer.ExportCommon;
import org.projectnessie.versioned.transfer.ExportContext;
import org.projectnessie.versioned.transfer.NessieExporter;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

final class ExportContents
extends ExportCommon {
    private final VersionStore store;
    private ByteString lastCommitId = ObjId.EMPTY_OBJ_ID.asBytes();

    ExportContents(ExportFileSupplier exportFiles, NessieExporter exporter, TransferTypes.ExportVersion exportVersion) {
        super(exportFiles, exporter, exportVersion);
        this.store = exporter.versionStore();
    }

    @Override
    void prepare(ExportContext exportContext) {
    }

    private <T> List<T> take(int n, Iterator<T> it) {
        ArrayList<T> result = new ArrayList<T>(n);
        while (n-- > 0 && it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    @Override
    TransferTypes.HeadsAndForks exportCommits(ExportContext exportContext) {
        ReferenceInfo ref;
        try {
            ref = this.store.getNamedRef(this.exporter.contentsFromBranch(), GetNamedRefsParams.DEFAULT);
        }
        catch (ReferenceNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            CommitObj commit = (CommitObj)this.exporter.persist().fetchTypedObj(TypeMapping.hashToObjId((Hash)ref.getHash()), (ObjType)StandardObjType.COMMIT, CommitObj.class);
            this.handleGenericObjs(this.transferRelatedObjects.commitRelatedObjects(commit));
        }
        catch (ObjNotFoundException commit) {
            // empty catch block
        }
        long startMicros = TimeUnit.MILLISECONDS.toMicros(this.currentTimestampMillis());
        long seq = 0L;
        try (PaginationIterator entries = this.store.getKeys((Ref)ref.getNamedRef(), null, false, VersionStore.KeyRestrictions.NO_KEY_RESTRICTIONS);){
            List batch;
            while (!(batch = this.take(this.exporter.contentsBatchSize(), (Iterator)entries)).isEmpty()) {
                ByteString meta = CommitMetaSerializer.METADATA_SERIALIZER.toBytes((Object)CommitMeta.fromMessage((String)String.format("Single branch export from '%s', part %d", ref.getNamedRef().getName(), seq + 1L)));
                long micros = TimeUnit.MILLISECONDS.toMicros(this.currentTimestampMillis());
                Hasher hasher = Hashing.sha256().newHasher();
                hasher.putBytes(meta.asReadOnlyByteBuffer());
                hasher.putBytes(this.lastCommitId.asReadOnlyByteBuffer());
                hasher.putLong(seq);
                hasher.putLong(micros);
                TransferTypes.Commit.Builder commitBuilder = TransferTypes.Commit.newBuilder().setMetadata(meta).setCommitSequence(seq++).setCreatedTimeMicros(micros).setParentCommitId(this.lastCommitId);
                Map values = this.store.getValues((Ref)ref.getHash(), (Collection)batch.stream().map(e -> e.getKey().contentKey()).collect(Collectors.toList()), false);
                for (Map.Entry entry : values.entrySet()) {
                    ContentKey key = (ContentKey)entry.getKey();
                    Content content = ((ContentResult)entry.getValue()).content();
                    TransferTypes.Operation op = this.putOperationFromCommit(key, Objects.requireNonNull(content, "content")).build();
                    hasher.putBytes(op.toByteArray());
                    commitBuilder.addOperations(op);
                    this.handleGenericObjs(this.transferRelatedObjects.contentRelatedObjects(content));
                }
                ByteString commitId = ByteString.copyFrom((byte[])hasher.hash().asBytes());
                commitBuilder.setCommitId(commitId);
                this.lastCommitId = commitId;
                exportContext.writeCommit(commitBuilder.build());
                this.exporter.progressListener().progress(ProgressEvent.COMMIT_WRITTEN);
            }
        }
        catch (ReferenceNotFoundException e3) {
            throw new RuntimeException(e3);
        }
        return TransferTypes.HeadsAndForks.newBuilder().setScanStartedAtInMicros(startMicros).addHeads(this.lastCommitId).build();
    }

    @Override
    void exportReferences(ExportContext exportContext) {
        Reference reference = this.exporter.persist().fetchReference(RefMapping.asBranchName((String)this.exporter.contentsFromBranch()));
        this.handleGenericObjs(this.transferRelatedObjects.referenceRelatedObjects(reference));
        ObjId extendedInfoObj = reference.extendedInfoObj();
        TransferTypes.Ref.Builder refBuilder = TransferTypes.Ref.newBuilder().setName(reference.name()).setPointer(this.lastCommitId);
        if (extendedInfoObj != null) {
            refBuilder.setExtendedInfoObj(extendedInfoObj.asBytes());
        }
        refBuilder.setCreatedAtMicros(this.exporter.persist().config().currentTimeMicros());
        exportContext.writeRef(refBuilder.build());
        this.exporter.progressListener().progress(ProgressEvent.NAMED_REFERENCE_WRITTEN);
    }

    private TransferTypes.Operation.Builder putOperationFromCommit(ContentKey key, Content value) {
        return TransferTypes.Operation.newBuilder().setOperationType(TransferTypes.OperationType.Put).addContentKey(TypeMapping.keyToStoreKey((ContentKey)key).rawString()).setContentId(value.getId()).setPayload(DefaultStoreWorker.payloadForContent((Content)value)).setValue(this.contentToValue(value));
    }

    private ByteString contentToValue(Content content) {
        try {
            return ByteString.copyFromUtf8((String)this.exporter.objectMapper().writeValueAsString((Object)content));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

