/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import java.io.IOException;
import org.projectnessie.nessie.relocated.protobuf.AbstractMessage;
import org.projectnessie.versioned.transfer.NessieExporter;
import org.projectnessie.versioned.transfer.SizeLimitedOutput;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

final class ExportContext {
    private final TransferTypes.ExportMeta.Builder exportMeta;
    final SizeLimitedOutput namedReferenceOutput;
    final SizeLimitedOutput commitOutput;
    final SizeLimitedOutput genericOutput;

    ExportContext(ExportFileSupplier exportFiles, NessieExporter exporter, TransferTypes.ExportMeta.Builder exportMeta) {
        this.exportMeta = exportMeta;
        this.namedReferenceOutput = new SizeLimitedOutput(exportFiles, exporter, "named-refs", arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).addNamedReferencesFiles(arg_0), arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).setNamedReferencesCount(arg_0));
        this.commitOutput = new SizeLimitedOutput(exportFiles, exporter, "commits", arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).addCommitsFiles(arg_0), arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).setCommitCount(arg_0));
        this.genericOutput = new SizeLimitedOutput(exportFiles, exporter, "custom", arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).addGenericObjFiles(arg_0), arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).setGenericObjCount(arg_0));
    }

    public void writeRef(TransferTypes.Ref ref) {
        this.namedReferenceOutput.writeEntity((AbstractMessage)ref);
    }

    void writeCommit(TransferTypes.Commit commit) {
        this.commitOutput.writeEntity((AbstractMessage)commit);
    }

    void writeGeneric(TransferTypes.RelatedObj custom) {
        this.genericOutput.writeEntity((AbstractMessage)custom);
    }

    TransferTypes.ExportMeta finish() throws IOException {
        this.namedReferenceOutput.finish();
        this.commitOutput.finish();
        this.genericOutput.finish();
        return this.exportMeta.build();
    }

    void closeSilently() {
        this.namedReferenceOutput.closeSilently();
        this.commitOutput.closeSilently();
        this.genericOutput.closeSilently();
    }
}

